import request from '../../utils/request'

/**
 * 重置用户密码信息
 */
export function resetPassword(data) {
  //参数信息AccountType AccountId
  return request({
    url: '/user/ResetUserPassword',
    method: 'post',
    data
  })
}

/**
 * 获取员工列表
 * @param {查询参数} data
 */
export function queryEmployee(data) {
  return request({
    url: '/user/GetEmployeeList',
    method: 'post',
    data
  })
}

export function checkStuTel(data) {
  return request({
    url: '/user/CheckExistsStu',
    method: 'post',
    data
  })
}

export function queryStudentByTel(data) {
  return request({
    url: '/User/GetStudentByTel',
    method: 'post',
    data
  })
}


/**
 * 修改离职信息
 * @param {查询参数} data
 */
export function UpdateEmployeeLeave(data) {
  return request({
    url: '/User/UpdateEmployeeLeaveTime',
    method: 'post',
    data
  })
}

/**
 * 修改部门
 * @param {查询参数} data
 */
export function UpdateEmployeeDept(data) {
  return request({
    url: '/User/UpdateEmployeeDept',
    method: 'post',
    data
  })
}

/**
 * 修改岗位
 * @param {查询参数} data
 */
export function UpdateEmployeePost(data) {
  return request({
    url: '/User/UpdateEmployeePost',
    method: 'post',
    data
  })
}

/**
 * 重置密码
 * @param {查询参数} data
 */
export function BatchResetUserPassword(data) {
  return request({
    url: '/User/BatchResetUserPassword',
    method: 'post',
    data
  })
}
/**
 * 获取部门Id
 */
export function getEmployeeAddrBook(data) {
  return request({
    url: '/User/GetEmployeeAddrBook',
    method: 'post',
    data
  })
}

/**
 * 个人资料修改
 */
export function setEmployeeBaseInfo(data) {
  return request({
    url: '/UserInfo/SetEmployeeBaseInfo',
    method: 'post',
    data
  })
}

/**
 * 个人资料-修改密码
 */
export function updateUserPassword(data) {
  return request({
    url: '/UserInfo/UpdateUserPassword',
    method: 'post',
    data
  })
}

/**
 * 获取个人中心信息
 */
export function getUserCenterInfo(data) {
  return request({
    url: '/UserInfo/GetUserCenterInfo',
    method: 'post',
    data
  })
}


/**
 * 获取我的提成折线图
 */
export function getUserSellCommission(data) {
  return request({
    url: '/UserInfo/GetUserSellCommission',
    method: 'post',
    data
  })
}
/**
 * 获取我的奖金折线图
 */
export function getTeacherSellCommission(data) {
  return request({
    url: '/UserInfo/GetTeacherSellCommission',
    method: 'post',
    data
  })
}
/**
 * 个人中心 我的奖金确认  
 */
export function updateSureTeachingBonusDetail(data) {
  return request({
    url: '/UserInfo/UpdateSureTeachingBonusDetail',
    method: 'post',
    data
  })
}

/**
 * 个人中心 我的提成确认  
 */
export function updatSureSellCommission(data) {
  return request({
    url: '/UserInfo/UpdatSureSellCommission',
    method: 'post',
    data
  })
}

/**
 * 修改员工职能
 * @param {查询参数} data
 */
export function UpdateEmployeeType(data) {
  return request({
    url: '/User/SetEmployeeType',
    method: 'post',
    data
  })
}

/**
 * 获取用户角色下拉
 * @param {查询参数} data
 */
export function GetUserRoleList(data) {
  return request({
    url: '/User/GetUserRoleList',
    method: 'post',
    data
  })
}

/**
 * 获取企业分页列表
 * @param {查询参数} data
 */
export function GetEnterprisePage(data) {
  return request({
    url: '/B2BCustomer/GetEnterprisePage',
    method: 'post',
    data
  })
}

/**
 * 获取企业下拉数据
 * @param {查询参数} data
 */
export function GetEnterpriseList(data) {
  return request({
    url: '/B2BCustomer/GetEnterpriseList',
    method: 'post',
    data
  })
}

/**
 * 新增修改企业信息
 * @param {查询参数} data
 */
export function SetEnterprise(data) {
  return request({
    url: '/B2BCustomer/SetEnterprise',
    method: 'post',
    data
  })
}

/**
 * 根据编号获取企业信息详情
 * @param {查询参数} data
 */
export function GetEnterprise(data) {
  return request({
    url: '/B2BCustomer/GetEnterprise',
    method: 'post',
    data
  })
}

/**
 * 根据编号删除企业信息
 * @param {查询参数} data
 */
export function RemoveEnterprise(data) {
  return request({
    url: '/B2BCustomer/RemoveEnterprise',
    method: 'post',
    data
  })
}

/**
 * 获取统计数据
 * @param {查询参数} data
 */
export function MarketChannelStudentStatic(data) {
  return request({
    url: '/UserCenter/MarketChannelStudentStatic',
    method: 'post',
    data
  })
}

/**
 * 获取到访转化统计
 * @param {查询参数} data
 */
export function MarketCreateType(data) {
  return request({
    url: '/UserCenter/MarketCreateType',
    method: 'post',
    data
  })
}

/**
 * 获取细分渠道
 * @param {查询参数} data
 */
export function MarketChannelStatic(data) {
  return request({
    url: '/UserCenter/MarketChannelStatic',
    method: 'post',
    data
  })
}


/**
 * 获取同行分页列表
 * @param {查询参数} data
 */
export function queryCustomerCategoryPage(data) {
  return request({
    url: '/B2BCustomer/GetCustomerCategoryPage',
    method: 'post',
    data
  })
}


/**
 * 获取同行列表
 * @param {查询参数} data
 */
export function queryCustomerCategoryList(data) {
  return request({
    url: '/B2BCustomer/GetCustomerCategoryList',
    method: 'post',
    data
  })
}


/**
 * 新增修改同行
 * @param {查询参数} data
 */
export function saveCustomerCategory(data) {
  return request({
    url: '/B2BCustomer/SetCustomerCategory',
    method: 'post',
    data
  })
}

/**
 * 根据编号获取同行信息
 * @param {查询参数} data
 */
export function queryCustomerCategory(data) {
  return request({
    url: '/B2BCustomer/GetCustomerCategory',
    method: 'post',
    data
  })
}

/**
 * 根据编号删除同行信息
 * @param {查询参数} data
 */
export function deleteCustomerCategory(data) {
  return request({
    url: '/B2BCustomer/RemoveCustomerCategory',
    method: 'post',
    data
  })
}

/**
 * 获取客户类型列表
 * @param {查询参数} data
 */
export function GetCatetoryTypeList(data) {
  return request({
    url: '/B2BCustomer/GetCatetoryTypeList',
    method: 'post',
    data
  })
}

/**
 * 保存合并
 * @param {查询参数} data
 */
export function ReplaceCategory(data) {
  return request({
    url: '/B2BCustomer/ReplaceCategory',
    method: 'post',
    data
  })
}