/**
 * 验证工具类
 */

/* 合法uri*/
export function validateURL(textval) {
    const urlregex = /^(https?|ftp):\/\/([a-zA-Z0-9.-]+(:[a-zA-Z0-9.&%$-]+)*@)*((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]?)(\.(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])){3}|([a-zA-Z0-9-]+\.)*[a-zA-Z0-9-]+\.(com|edu|gov|int|mil|net|org|biz|arpa|info|name|pro|aero|coop|museum|[a-zA-Z]{2}))(:[0-9]+)*(\/($|[a-zA-Z0-9.,?'\\+&%$#=~_-]+))*$/
    return urlregex.test(textval)
}

/* 小写字母*/
export function validateLowerCase(str) {
    const reg = /^[a-z]+$/
    return reg.test(str)
}

/* 大写字母*/
export function validateUpperCase(str) {
    const reg = /^[A-Z]+$/
    return reg.test(str)
}

/* 大小写字母*/
export function validatAlphabets(str) {
    const reg = /^[A-Za-z]+$/
    return reg.test(str)
}

/** 比对数组是否相同 */
export function compareArray(arrA, arrB) {
    let isSame = true
    if (arrA.length !== arrB.length) {
      return false
    } else {
      arrA.some((el, idx) => {
        if (el !== arrB[idx]) {
          isSame = false
          return true
        }
      })
    }
    return isSame
}

/** 比对对象是否相同 */
export function compareObject(objA, objB,ignoreArray, endLoop) {
    let isSame = true
    let isArray = '[object Array]'
    let isObject = '[object Object]'
    for (var key in objA) {
    if (objB[key] !== '' && !objB[key] && typeof objB[key] !== 'number') {
        isSame = false
        break
    }
    let type = Object.prototype.toString.call(objA[key])
    if (type === isArray && ignoreArray) {
        isSame = compareArray(objA[key], objB[key])
    } else if (type === isObject) {
        isSame = compareObject(objA[key], objB[key],ignoreArray)
    } else if (objA[key] !== objB[key]) {
        isSame = false
    }

    if (!isSame) {
        return isSame
    }
    }
    if (isSame && !endLoop) {
    isSame = compareObject(objB, objA,ignoreArray, true)
    }
    return isSame
}

//验证11位的号码
export function validateTel(tel) {
    const reg = /^1[3|4|5|6|7|8|9]\d{9}$/
    return reg.test(tel)
}