
/*!
  导出简易excel
  param tableH 表头数据
  param tableDataList 表格数据
  param tableFooterDataList 表格底部数据
*/
import XLSX from 'xlsx/types';
let downloadExcelEasy = {
  downLoad: function (tableH, tableDataList, tableFooterDataList) {
    // 导出文件名
    let xlsxName = '团队营收报表';
    // 数据源
    let dataSource = tableDataList;
    let wscols = {};
    // 每列的宽度
    wscols = [];
    // 创建表头数据
    let data = [tableH];
    // 组装表格内容
    dataSource.forEach((x,index)=>{
      let obj = [];
      obj.push(x.LineName+" ");
      obj.push(x.TCNUM);
      obj.push(x.TCID);
      obj.push('否');
      for (let i = 0 ; i <= data[0].length-5 ; i++ ) {
        obj.push(Math.random()*9999);
      }
      data.push(obj);
    });
    // 表格底部
    if (tableFooterDataList) {
      let obj = [];
      tableFooterDataList[0].forEach(x=> {
        obj.push(x);
      });
      data.push(obj);
    }
    let colName = downloadExcelEasy.countColumn(tableH);
    const ws = XLSX.utils.aoa_to_sheet(data);
    ws['!cols'] = wscols;
    ws['!rows'] = [];
    const wb = XLSX.utils.book_new();
    XLSX.utils.book_append_sheet(wb, ws, xlsxName);
    var dataInfo = wb.Sheets[wb.SheetNames[0]];
    data[0].forEach((x,i)=>{
      dataInfo[colName[i]+'1'].s={
        fill: { fgColor: { rgb: "#ffff00"}},
        font: {
          name: '微软雅黑',
          sz: 32,
          color: { rgb: "#ffff00"},
          bold: true,
          italic: true,
          underline: true
        },
        alignment: {
          horizontal: "center",
          vertical: "center"
        }
      }
    });
    XLSX.writeFile(wb, xlsxName + ".xlsx")
  },
  countColumn: function (data) {
    let list = [];
    let col = ['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'];
    data.forEach((item , index)=> {
      if (index < 26){
        list.push(col[index])
      }else if (index > 25 && index < 52) {
        list.push('A'+col[index-col.length])
      }else if (index > 51 && index < 78) {
        list.push('B'+col[index-(col.length*2)])
      }
    });
    return list
  }
};
export default downloadExcelEasy
