import axios from 'axios'
import cache from './cache'
import Lockr from 'lockr'
import store from '../store'

/** 移除授权信息 */
export function removeAuth() {
    return new Promise((resolve, reject) => {
        cache.rmAxiosCache()
            //store.commit('SET_ALLAUTH', null)
        delete axios.defaults.headers['Token']
        resolve(true)
    })
}

/** 注入授权信息 */
export function addAuth(adminToken) {
    return new Promise((resolve, reject) => {
        axios.defaults.headers['Token'] = adminToken
        resolve(true)
    })
}

/** 获取授权信息 */
export function getAuth() {
    if (Lockr.get('Token') && !axios.defaults.headers['Token']) {
        cache.updateAxiosCache()
    }

    if (axios.defaults.headers['Token']) {
        return true
    }
    return false
}