const routes = [{
    path: "/",
    component: () =>
      import("pages/user/login.vue")
  },
  {
    path: "/login",
    component: () =>
      import("pages/user/login.vue")
  },
  {
    path: "/home",
    component: () =>
      import("layouts/MainLayout.vue"),
    children: [{
        path: "",
        component: () =>
          import("src/pages/Work.vue")
      },
      {
        path: "/school/manager",
        component: () =>
          import("pages/school/manager.vue")
      },
      {
        path: "/school/teacher",
        component: () =>
          import("pages/school/teacher.vue")
      },
      {
        path: "/school/assistant",
        component: () =>
          import("pages/school/assistant.vue")
      },
      {
        path: "/school/classroom", //教室管理
        component: () =>
          import("pages/school/classroom.vue")
      },
      {
        path: "/school/student", //学员管理
        component: () =>
          import("pages/school/student.vue")
      },
      {
        path: "/school/sysuser", //后台用户管理
        component: () =>
          import("pages/school/sysuser.vue")
      },
      {
        path: "/system/menu", //菜单管理
        component: () =>
          import("pages/system/menu.vue")
      },
      {
        path: "/system/menufunction", //菜单功能权限管理
        component: () =>
          import("pages/system/menufunction.vue")
      },
      {
        path: "/system/dept", //部门管理
        component: () =>
          import("pages/system/dept.vue")
      },
      {
        path: "/system/deptrelation", //部门关系图
        component: () =>
          import("pages/system/deptrelation.vue")
      },
      {
        path: "/system/post", //岗位管理
        component: () =>
          import("pages/system/post.vue")
      },
      {
        path: "/system/role", //角色管理
        component: () =>
          import("pages/system/role.vue")
      },
      {
        path: "/system/siteconfig", //站点配置
        component: () =>
          import("pages/system/siteconfig.vue")
      },
      {
        path: "/system/msgmanage", //短信管理
        component: () =>
          import("pages/system/msgmanage.vue")
      },
      {
        path: "/system/processSet", //流程配置
        component: () =>
          import("pages/system/processSet.vue")
      },
      {
        path: "/system/okrmanage", //OKR设置
        component: () =>
          import("pages/system/okrmanage.vue")
      },
      {
        path: "/system/webkitManage", //网站管理
        component: () =>
        import("pages/system/webkitManage.vue")
      },
      {
        path: "/system/menuManage", //菜单管理
        component: () =>
        import("pages/system/menuManage.vue")
      },
      {
        path: "/system/newsType", //新闻类型
        component: () =>
        import("pages/system/newsType.vue")
      },
      {
        path: "/system/news", //新闻列表
        component: () =>
        import("pages/system/news.vue")
      },
      {
        path: "/system/teacherManage", //教师团队管理
        component: () =>
        import("pages/system/teacherManage.vue")
      },
      {
        path: "/system/consultManage", //咨询管理
        component: () =>
        import("pages/system/consultManage.vue")
      },
      {
        path: "/system/comicManage", //品牌漫画管理
        component: () =>
        import("pages/system/comicManage.vue")
      },
      {
        path: "/system/monthlyManage", //品牌月刊管理
        component: () =>
        import("pages/system/monthlyManage.vue")
      },
      {
        path: "/system/recruitment", // 招聘管理
        component: () =>
        import("pages/system/recruitment.vue")
      },
      {
        path: "/system/recruitmentType", //招聘类型
        component: () =>
        import("pages/system/recruitmentType.vue")
      },
      {
        path: "/system/jobapplyManage", //招聘申请管理
        component: () =>
        import("pages/system/jobapplyManage.vue")
      },
      {
        path: "/course/catagory", //课程分类
        component: () =>
          import("pages/course/catagory.vue")
      },
      {
        path: "/course/course", //课程管理
        component: () =>
          import("pages/course/course.vue")
      },
      {
        path: "/course/classManage", //班级管理
        component: () =>
          import("pages/course/classManage.vue")
      },
      {
        path: "/course/baseSet", //基础设置
        component: () =>
          import("pages/course/baseSet.vue")
      },
      {
        path: "/course/paymentDetail", //收支明细
        component: () =>
          import("pages/course/paymentDetail.vue")
      },
      {
        path: "/course/classorder", //班级订单
        component: () =>
          import("pages/course/classorder.vue")
      },
      {
        path: "/course/socialclass", //教学奖励-社会班设置
        component: () =>
          import("pages/course/socialclass.vue")
      },
      {
        path: "/course/studentClass", //教学奖励-学生班设置
        component: () =>
          import("pages/course/studentClass.vue")
      },
      {
        path: "/course/teacherLesson", //教师备课列表
        component: () =>
          import("pages/course/teacherLesson.vue")
      },
      {
        path: "/course/lessonPreparation", //教师备课
        component: () =>
          import("pages/course/lessonPreparation.vue")
      },
      {
        path: "/course/prepareclassDetails", //教师备课 备课详情
        component: () =>
          import("pages/course/prepareclassDetails.vue")
      },
      {
        path: "/financial/PlatformAccount", //平台账户
        component: () =>
          import("pages/financial/PlatformAccount.vue")
      },
      {
        path: "/financial/CompanyAccount", //银行账户
        component: () =>
          import("pages/financial/CompanyAccount.vue")
      },
      {
        path: "/financial/TeamRevenueReport", //营收报表
        component: () =>
          import("pages/financial/TeamRevenueReport.vue")
      },
      {
        path: "/financial/EasyReport", //简易报表
        component: () =>
          import("pages/financial/EasyReport.vue")
      },
      {
        path: "/financial/orderCompleteStatistics", //订单完成统计
        component: () =>
          import("pages/financial/orderCompleteStatistics.vue")
      },
      
      {
        path: "/financial/JumpReport", //单据明细
        component: () =>
          import("pages/financial/JumpReport.vue")
      },
      {
        path: "/financial/institutionsManagement", //金融机构管理
        component: () =>
          import("pages/financial/institutionsManagement.vue")
      },
      {
        path: "/financial/currencyManagement", //币种管理
        component: () =>
          import("pages/financial/currencyManagement.vue")
      },
      {
        path: "/financial/AccountType", //账户类型
        component: () =>
          import("pages/financial/AccountType.vue")
      },
      {
        path: "/financial/AccountPageList", //关联账户
        component: () =>
          import("pages/financial/AccountPageList.vue")
      },
      {
        path: "/financial/CostType", //费用类型
        component: () =>
          import("pages/financial/CostType.vue")
      },
      {
        path: "/financial/paySetting", //支付配置管理
        component: () =>
          import("pages/financial/paySetting.vue")
      },
      {
        path: '/financial/HistoryRateQuery', //历史汇率
        component: () =>
          import("pages/financial/HistoryRateQuery.vue")
      },
      {
        path: "/financial/Maninfo", //未认款信息
        component: () =>
          import("pages/financial/Maninfo.vue")
      },
      {
        path: "/financial/Manfunds", //未认款管理
        component: () =>
          import("pages/financial/Manfunds.vue")
      },
      {
        path: "/financial/HuiChaImport", //汇差批量制单
        component: () =>
          import("pages/financial/HuiChaImport.vue")
      },
      {
        path: "/financial/CashAccount", //汇差批量制单
        component: () =>
          import("pages/financial/CashAccount.vue")
      },
      {
        path: "/financial/sellCommissionRules", //提成规则
        component: () =>
          import("pages/financial/sellCommissionRules.vue")
      },
      {
        path: "/financial/FProcessManagement", //流程管理、
        component: () =>
          import("pages/financial/FProcessManagement.vue")
      },
      {
        path: "/financial/XProcessManagement", //资产流程管理、
        component: () =>
          import("pages/financial/XProcessManagement.vue")
      },
      {
        path: "/financial/addFinancialProcess", //新增修改等级
        component: () =>
          import("pages/financial/addFinancialProcess.vue")
      },
      {
        path: "/financial/XaddFinancialProcess", //新增修改资产流程
        component: () =>
          import("pages/financial/XaddFinancialProcess.vue")
      },
      {
        path: "/financial/accountingWork", //会计窗口
        component: () =>
          import("pages/financial/accountingWork.vue")
      },
      {
        path: "/financial/CashierWork", //出纳窗口
        component: () =>
          import("pages/financial/CashierWork.vue")
      },
      {
        path: "/financial/empBankAccount", //常用付款对象
        component: () =>
          import("pages/financial/empBankAccount.vue")
      },
      {
        path: "/financial/accDetail/CashAccDetail", //现金账户明细
        component: () =>
          import("pages/financial/accDetail/CashAccDetail.vue")
      },
      {
        path: "/financial/accDetail/CompanyAccDetail", //银行账户明细
        component: () =>
          import("pages/financial/accDetail/CompanyAccDetail.vue")
      },
      {
        path: "/financial/accDetail/PlatformAccDetail", //平台账户明细
        component: () =>
          import("pages/financial/accDetail/PlatformAccDetail.vue")
      },
      {
        path: "/financial/accDetail/TransferReport", //银行日报表
        component: () =>
          import("pages/financial/accDetail/TransferReport.vue")
      },
      {
        path: "/financial/accDetail/CashReport", //现金日报表
        component: () =>
          import("pages/financial/accDetail/CashReport.vue")
      }, {
        path: "/financial/accDetail/CashReport", //现金日报表
        component: () =>
          import("pages/financial/accDetail/CashReport.vue")
      },
      {
        path: "/financial/financalDocument/ChoiceAddFinancialDocuments",
        component: () =>
          import("pages/financial/financalDocument/ChoiceAddFinancialDocuments.vue")
      },
      {
        path: "/financial/financalDocument/addReceivablesDocuments",
        component: () =>
          import("pages/financial/financalDocument/addReceivablesDocuments.vue")
      },
      {
        path: "/financial/financalDocument/invoicesManager", //发票管理
        component: () =>
          import("pages/financial/financalDocument/invoicesManager.vue")
      },
      {
        path: "/financial/financalDocument/refundQuery", //发票管理
        component: () =>
          import("pages/financial/financalDocument/refundQuery.vue")
      },
      {
        path: "/financial/financalDocument/CapitalAllocation", //资金调拨
        component: () =>
          import("pages/financial/financalDocument/CapitalAllocation.vue")
      },
      {
        path: "/financial/financalDocument/addCapitalAllocation", //资金调拨 新增
        component: () =>
          import("pages/financial/financalDocument/addCapitalAllocation.vue")
      },
      {
        path: "/financial/financalDocument/RecPayQuery", //收支查询
        component: () =>
          import("pages/financial/financalDocument/RecPayQuery.vue")
      },
      {
        path: "/financial/financalDocument/FinancialDocuments", //我的财务单据
        component: () =>
          import("pages/financial/financalDocument/FinancialDocuments.vue")
      },
      {
        path: "/financial/financalDocument/GetWOrkTransferPageLis", //员工财务单据转交
        component: () =>
          import("pages/financial/financalDocument/GetWOrkTransferPageLis.vue")
      },
      {
        path: "/financial/financalDocument/WorkEntrustmentMy", //工作委托
        component: () =>
          import("pages/financial/financalDocument/WorkEntrustmentMy.vue")
      },
      {
        path: "/financial/financalDocument/CapitalAllocationDetail", //资金调拨单 详情
        component: () =>
          import("pages/financial/financalDocument/CapitalAllocationDetail.vue")
      },
      {
        path: "/financial/financalDocument/addFinancialDocuments", //新增财务单据
        component: () =>
          import("pages/financial/financalDocument/addFinancialDocuments.vue")
      },
      {
        path: "/financial/financalDocument/FinancialDocumentsDetail", //我的财务单据详情
        component: () =>
          import("pages/financial/financalDocument/FinancialDocumentsDetail.vue")
      },
      {
        path: "/financial/financalDocument/BasicDocuments", //财务 财务单据 审核标准单据
        component: () =>
          import("pages/financial/financalDocument/BasicDocuments.vue")
      },
      {
        path: "/administration/document", //行政公告
        component: () =>
          import("pages/administration/document.vue")
      },
      {
        path: "/administration/Approval", //行政审批
        component: () =>
          import("pages/administration/Approval.vue")
      },
      {
        path: "/administration/ApprovalProcess", //审批流程详情
        component: () =>
          import("pages/administration/ApprovalProcess.vue")
      },
      {
        path: "/administration/processDesign", //分条件审批
        component: () =>
          import("pages/administration/processDesign.vue")
      },
      {
        path: "/administration/updateProcessDesign", //分条件审批
        component: () =>
          import("pages/administration/updateProcessDesign.vue")
      },
      {
        path: "/administration/myApprovalList", //我的审批
        component: () =>
          import("pages/administration/myApprovalList.vue")
      },
      {
        path: "/administration/myApproval", //我的发起
        component: () =>
          import("pages/administration/myApproval.vue")
      }, {
        path: "/administration/forMyApproval", //我的审批
        component: () =>
          import("pages/administration/forMyApproval.vue")
      },
      {
        path: "/administration/ApprovalStatistical", //审批统计
        component: () =>
          import("pages/administration/ApprovalStatistical.vue")
      },
      {
        path: "/administration/sendToMeApproval", //抄送
        component: () =>
          import("pages/administration/sendToMeApproval.vue")
      },
      {
        path: "/administration/leaveApproval", //请假
        component: () =>
          import("pages/administration/leaveApproval.vue")
      },
      {
        path: "/administration/Attendance", //考勤管理
        component: () =>
          import("pages/administration/Attendance.vue")
      },
      {
        path: "/administration/AttendanceRules", //考勤设置
        component: () =>
          import("pages/administration/AttendanceRules.vue")
      },
      {
        path: "/administration/outWorkApproval", //外勤考勤
        component: () =>
          import("pages/administration/outWorkApproval.vue")
      },
      {
        path: "/sale/japaneseTrain", //日语培训列表
        component: () =>
          import("pages/sale/japaneseTrain.vue")
      },
      {
        path: "/sale/courseList", //销售 课程预览
        component: () =>
          import("pages/sale/courseList.vue")
      },
      {
        path: "/sale/studyjob", //留学就业产品
        component: () =>
          import("pages/sale/studyjob.vue")
      },
      {
        path: "/sale/courseoffer", //销售 报价单管理
        component: () =>
          import("pages/sale/courseoffer.vue")
      },
      {
        path: "/sale/myoffer", //销售 我的报价单
        component: () =>
          import("pages/sale/myoffer.vue")
      },
      {
        path: "/sale/myOrder", //销售 我的订单
        component: () =>
          import("pages/sale/myOrder.vue")
      },
      {
        path: "/sale/orderStatistics", //销售 报名统计
        component: () =>
          import("pages/sale/orderStatistics.vue")
      },
      {
        path: "/sale/studyOrder", //销售 我的留学就业订单
        component: () =>
          import("pages/sale/studyOrder.vue")
      },
      {
        path: "/sale/studyOrderStatistics", //销售 我的留学就业订单统计
        component: () =>
          import("pages/sale/studyOrderStatistics.vue")
      },
      {
        path: "/sale/contractManage", //销售 合同管理
        component: () =>
          import("pages/sale/contractManage.vue")
      },
      {
        path: "/sale/contractEdit", //销售 新增-编辑-查看合同
        component: () =>
          import("pages/sale/contractEdit.vue")
      },
      {
        path: "/sale/contractAudit", //销售 合同审核
        component: () =>
          import("pages/sale/contractAudit.vue")
      },
      {
        path: "/sale/studentList", //销售 学生名单
        component: () =>
          import("pages/sale/studentList.vue")
      },
      {
        path: "/course/classHourReward", //教学奖励 课时奖励
        component: () =>
          import("pages/course/classHourReward.vue")
      },
      {
        path: "/course/rewardDetailed", //教学奖励 奖励明细
        component: () =>
          import("pages/course/rewardDetailed.vue")
      },
      {
        path: "/course/achievements", //教学奖励 绩效列表
        component: () =>
          import("pages/course/achievements.vue")
      },
      {
        path: "/user/backbill", //退课单据
        component: () =>
          import("pages/user/backbill.vue")
      },
      {
        path: "/course/questionlist", //题库列表
        component: () =>
          import("pages/course/questionlist.vue")
      },
      {
        path: "/course/question", //题库列表
        component: () =>
          import("pages/course/question.vue")
      },
      {
        path: "/course/questionInfo", //题库详情
        component: () =>
        import("pages/course/questionInfo.vue")
      },
      {
        path: "/sale/quotation", //报价单
        component: () =>
          import("pages/sale/quotation.vue")
      },
      {
        path: "/course/courseinfo",
        component: () => import("pages/course/courseinfo.vue"),
        children: [{
            path: "/course/teachplan", //教案管理
            component: () =>
              import("pages/course/teachplan.vue")
          },
          {
            path: "/course/chapter", //章节管理
            component: () =>
              import("pages/course/chapter.vue")
          },
          {
            path: "/course/coursejob", //作业管理
            component: () =>
              import("pages/course/coursejob.vue")
          },

        ]
      },
      {
        path: "/course/jobinfo", //作业详情管理
        component: () =>
          import("pages/course/jobinfo.vue")
      },
      {
        path: "/studyAbroad/studyabroad", //留学
        component: () =>
          import("pages/studyAbroad/studyabroad.vue")
      },
      {
        path: "/studyAbroad/employment", //就业
        component: () =>
          import("pages/studyAbroad/employment.vue")
      },
      {
        path: "/studyAbroad/studyemploymentorder", //留学就业订单中心
        component: () =>
          import("pages/studyAbroad/studyemploymentorder.vue")
      },
      {
        path: "/studyAbroad/studypayment", //留学就业收支明细
        component: () =>
          import("pages/studyAbroad/studypayment.vue")
      },
      {
        path: "/studyAbroad/supplier", //供应商
        component: () =>
          import("pages/studyAbroad/supplier.vue")
      },
      {
        path: "/studyAbroad/studyProAudit", //留学产品审核
        component: () =>
          import("pages/studyAbroad/studyProAudit.vue")
      },
      {
        path: "/test", //API测试
        component: () =>
          import("pages/test.vue")
      },
    ]
  },
  // Always leave this as last one,
  // but you can also remove it
  {
    path: "/contractConfirm",
    component: () =>
      import("pages/contractConfirm.vue")
  },
  //公告预览
  {
    path: "/noticeView",
    component: () =>
    import("pages/noticeView.vue")
  },
  {
    path: "/contractView",
    component: () =>
      import("pages/contractView.vue")
  },
  {
    path: "/financial/financalDocument/PrintPage", //财务单据打印
    component: () =>
      import("pages/financial/financalDocument/PrintPage.vue")
  },
  {
    path: "/financial/financalDocument/PrintPageN", //财务凭证打印
    component: () =>
      import("pages/financial/financalDocument/PrintPageN.vue")
  },
  {
    path: '/AssetsShenpi', //资产管理审批
    name: 'AssetsShenpi',
    component: () => import('pages/administration/AssetsSystem/AssetsShenpi'),
    meta: {
      title: '资产管理'
    },
  },
  {
    path: "*",
    component: () =>
      import("pages/Error404.vue")
  }
];

export default routes;
