import router from "../router/index";
import store from "../store/index";
import { LoadingBar, Notify } from "quasar";
import { getAuth } from "../utils/auth"; // 验权
LoadingBar.setDefaults({
    color: "primary",
    size: "5px",
    position: "bottom"
});
let loadAsyncRouter = false;
const whiteList = ["/login", "/"]; // 不重定向白名单
router.beforeEach((to, from, next) => {
    localStorage.setItem("routerBefore", from.path);
    LoadingBar.start();
    /** 请求头包含授权信息 并且 页面必须授权 直接进入 */
    if (getAuth()) {
        //debugger;
        if (to.path === "/login" || to.path === "/") {
            next({
                path: "/home"
            });
            LoadingBar.stop();
        } else {
            if (!loadAsyncRouter) {
                // 判断当前用户是否获取权限
                loadAsyncRouter = true;
                if (store.getters.allAuth) {
                    store.dispatch("GenerateRoutes", store.getters.allAuth).then(() => {
                        // 根据auths权限生成可访问的路由表
                        //router.addRoutes(store.getters.addRouters); // 动态添加可访问路由表
                        if (to.path === "/404") {
                            next({
                                path: to.redirectedFrom || "/",
                                replace: true
                            });
                        } else {
                            next({
                                ...to,
                                replace: true
                            });
                            LoadingBar.stop();
                        }
                    });
                } else {
                    store
                        .dispatch("getAuth")
                        .then(auths => {
                            // 拉取user_info
                            store.dispatch("GenerateRoutes", auths).then(() => {
                                // 根据auths权限生成可访问的路由表
                                router.addRoutes(store.getters.addRouters); // 动态添加可访问路由表
                                if (to.path === "/404") {
                                    next({
                                        path: to.redirectedFrom || "/",
                                        replace: true
                                    });
                                    LoadingBar.stop();
                                } else {
                                    next({
                                        ...to,
                                        replace: true
                                    });
                                    LoadingBar.stop();
                                }
                            });
                        })
                        .catch(err => {
                            loadAsyncRouter = false;
                            store.dispatch("LogOut").then(() => {
                                Notify.create({
                                    icon: "error",
                                    color: "negative",
                                    message: err.msg || "获取用户信息失败",
                                    position: "top"
                                });
                                next({
                                    path: "/"
                                });
                            });
                        });
                }
            } else {
                next();
            }
        }
    } else {
        if (whiteList.indexOf(to.path) !== -1) {
            next();
        } else {
            next(`/login?redirect=${to.path}`); // 否则全部重定向到登录页
            LoadingBar.stop();
        }
    }
});

router.afterEach(() => {
    LoadingBar.stop(); // 结束Progress
});

router.onError(error => {
    const pattern = /Loading chunk (\d)+ failed/g;
    const isChunkLoadFailed = error.message.match(pattern);
    const targetPath = router.history.pending.fullPath;
    if (isChunkLoadFailed) {
        router.replace(targetPath);
    }
});