import request from '../../utils/request'

/**
 * 获取课程分页列表
 * @param {JSON参数} data 
 */
export function queryCourseCategoryPage(data) {
  return request({
    url: '/Course/GetCourseCategoryPageList',
    method: 'post',
    data
  })
}

/**
 * 获取课程分类树形列表
 */
export function queryCourseCategoryTree(data) {
  return request({
    url: '/Course/GetCourseCategoryTree',
    method: 'post',
    data
  })
}

/**
 * 根据编号获取课程分类信息
 */
export function queryCourseCategoryInfo(data) {
  return request({
    url: '/Course/GetCourseCategory',
    method: 'post',
    data
  })
}

/**
 * 保存课程分类
 * @param {JSON参数} data 
 */
export function saveCourseCategoryInfo(data) {
  return request({
    url: '/Course/SetCourseCategory',
    method: 'post',
    data
  })
}

/**
 * 删除课程分类
 * @param {JOSN参数} data 
 */
export function deleteCourseCategory(data) {
  return request({
    url: '/Course/RemoveCourseCategory',
    method: 'post',
    data
  })

}

/**
 * 获取课程分页列表
 * @param {JSON参数} data 
 */
export function queryCoursePage(data) {
  return request({
    url: '/Course/GetCoursePageList',
    method: 'post',
    data
  })
}


/**
 * 获取课程下拉列表
 * @param {JSON对象} data 
 */
export function queryCourseDropdownList(data) {
  return request({
    url: '/Course/GetCourseList',
    method: 'post',
    data
  })
}

/**
 * 获取课程详情
 * @param {JSON参数} data 
 */
export function queryCourseInfo(data) {
  return request({
    url: '/Course/GetCourse',
    method: 'post',
    data
  })
}

/**
 * 保存课程详情
 */
export function saveCourseInfo(data) {
  return request({
    url: '/Course/SetCourse',
    method: 'post',
    data
  })
}

/**
 * 删除课程详情
 * @param {JSON对象} data 
 */
export function deleteCourseInfo(data) {
  return request({
    url: '/Course/RemoveCourse',
    method: 'post',
    data
  })
}


/**
 * 设置是否显示课程章节
 * @param {JSON对象} data 
 */
export function updateCourseIsShowChapterNo(data) {
  return request({
    url: "/Course/SetCourseIsShowChapterNo",
    method: 'post',
    data
  })
}

/**
 * 设置课程教师
 * @param {JSON参数} data 
 */
export function updateCourseTeacher(data) {
  return request({
    url: "/Course/SetCourseTeacher",
    method: 'post',
    data
  })
}

/**
 * 获取课程教案分页
 * @param {JSON对象} data 
 */
export function queryTeachPlanPage(data) {
  return request({
    url: "/Course/GetCourseTeachPlanPage",
    method: 'post',
    data
  })
}

/**
 * 获取课程教案信息
 */
export function queryTeachPlanInfo(data) {
  return request({
    url: "/Course/GetTeachPlan",
    method: 'post',
    data
  })
}

/**
 * 保存课程教案
 * @param {JSON数据} data 
 */
export function saveTeachPlanInfo(data) {
  return request({
    url: "/Course/SetTeachPlan",
    method: 'post',
    data
  })
}

/**
 * 删除课程教案
 * @param {JSON参数} data 
 */
export function removeTeachPlanInfo(data) {
  return request({
    url: "/Course/RemoveTeachPlan",
    method: 'post',
    data
  })
}

/**
 * 获取课程章节树形列表
 * @param {JSON参数} data 
 */
export function queryChapterTree(data) {
  return request({
    url: "/Course/GetChapterTree",
    method: 'post',
    data
  })
}
