import request from '../../utils/request'

/**
 * 获取菜单类型列表
 */
export function getMenuTypeList() {
  var MenuTypeOpts = [{
      label: '全部',
      value: -1
    },
    {
      label: '管理端',
      value: 1
    },
    {
      label: '教师端',
      value: 2
    },
    {
      label: '助教端',
      value: 3
    },
    {
      label: '学生端',
      value: 4
    }
  ];
  return MenuTypeOpts;
}

/**
 * 获取菜单等级列表
 */
export function getMenuLevelList() {
  var MenuLevelOpts = [{
      label: '全部',
      value: -1
    },
    {
      label: '一级',
      value: 1
    },
    {
      label: '二级',
      value: 2
    },
    {
      label: '三级',
      value: 3
    }
  ];
  return MenuLevelOpts;
}

/**
 * 获取部门层级列表
 */
export function getDeptTierList() {
  var deptTierOpts = [{
      label: '1级',
      value: 1
    },
    {
      label: '2级',
      value: 2
    },
    {
      label: '3级',
      value: 3
    },
    {
      label: '4级',
      value: 4
    },
    {
      label: '5级',
      value: 5
    },
    {
      label: '6级',
      value: 6
    },
    {
      label: '7级',
      value: 7
    },
    {
      label: '8级',
      value: 8
    },
    {
      label: '9级',
      value: 9
    },
    {
      label: '10级',
      value: 10
    },
  ];
  return deptTierOpts;
}

/**
 * 获取菜单分页列表
 * 
 */
export function getMenuPage(data) {
  return request({
    url: '/Public/GetMenuPageList',
    method: 'post',
    data
  })
}

/**
 * 获取菜单类表
 * @param {参数} data 
 */
export function getMenuList(data) {
  return request({
    url: '/Public/GetMenuList',
    method: 'post',
    data
  })
}

/**
 * 获取菜单详情
 * @param {JSON参数} data 
 */
export function getMenuInfo(data) {
  return request({
    url: '/Public/GetMenu',
    method: 'post',
    data
  })
}

/**
 * 保存菜单
 * @param {菜单实体} data 
 */
export function saveMenu(data) {
  return request({
    url: '/Public/SetMenu',
    method: 'post',
    data
  })
}

/**
 * 设置菜单状态
 * @param {JSON参数对象} data 
 */
export function updateMenuStatus(data) {
  return request({
    url: '/Public/SetMenuStatus',
    method: 'post',
    data
  })
}

/**
 * 获取树形结构菜单
 * @param {JSON参数} data 
 */
export function queryTreeMenu(data) {
  return request({
    url: '/Public/GetTreeMenu',
    method: 'post',
    data
  })
}


/**
 * 获取角色分页列表
 * @param {JSON参数} data 
 */
export function queryRolePage(data) {
  return request({
    url: '/Public/GetRolePageList',
    method: 'post',
    data
  })
}

/**
 * 获取角色列表
 * @param {JSON参数} data 
 */
export function queryRoleDropdown(data) {
  return request({
    url: '/Public/GetRoleList',
    method: 'post',
    data
  })
}

/**
 * 获取角色详情
 * @param {JSON参数} data 
 */
export function queryRoleInfo(data) {
  return request({
    url: '/Public/GetRole',
    method: 'post',
    data
  })
}

/**
 * 保存角色
 * @param {JSON参数} data 
 */
export function saveRoleInfo(data) {
  return request({
    url: '/Public/SetRole',
    method: 'post',
    data
  })
}

/**
 * 修改角色状态
 * @param {JSON对象} data 
 */
export function setRoleStatus(data) {
  return request({
    url: '/Public/SetRoleStatus',
    method: 'post',
    data
  })
}

/**
 * 获取角色菜单和功能权限
 * @param {JSON对象} data 
 */
export function GetRolePermission(data) {
  return request({
    url: '/Public/GetRolePermission',
    method: 'post',
    data
  })
}

/**
 * 保存角色权限
 */
export function SetRolePermission(data) {
  return request({
    url: '/Public/SetRolePermission',
    method: 'post',
    data
  })
}
