import request from '../../utils/request'

/**
 * 获取部门分页列表
 */
export function getDeptPage(data) {
  return request({
    url: '/User/GetDeptPageList',
    method: 'post',
    data
  });
}

/**
 * 获取部门列表
 */
export function getDeptList(data) {
  return request({
    url: '/User/GetDeptList',
    method: 'post',
    data
  });
}

/**
 * 获取部门树形列表
 */
export function getDeptTree(data) {
  return request({
    url: '/User/GetDeptTree',
    method: 'post',
    data
  });
}

/**
 * 获取组织机构图
 */
export function getOrganizationChart(data) {
  return request({
    url: '/User/GetOrganizationChart',
    method: 'post',
    data
  });
}

/**
 * 新增修改部门信息
 */
export function saveDeptInfo(data) {
  return request({
    url: '/User/SetDept',
    method: 'post',
    data
  });
}

/**
 * 获取部门信息
 */
export function getDeptInfo(data) {
  return request({
    url: '/User/GetDept',
    method: 'post',
    data
  });
}

/**
 * 设置部门状态
 */
export function setDeptStatusInfo(data) {
  return request({
    url: '/User/RemoveDept',
    method: 'post',
    data
  });
}

/**
 * 获取下级部门
 * @param DeptId 上级部门编号
*/
export function getChildDepartment(DeptId)
{
    return request({
        url: '/User/RemoveDept',
        method: 'post',
        data:{DeptId:DeptId}
      });
}
