import Vue from 'vue'
import VueI18n from 'vue-i18n'
import messages from 'src/i18n'
import '../../public/static/UE/ueditor.config.js'
import '../../public/static/UE/ueditor.all.js'
import '../../public/static/UE/lang/zh-cn/zh-cn.js'
import '../../public/static/UE/ueditor.parse.min.js'
Vue.use(VueI18n)

const i18n = new VueI18n({
  locale: 'zh-CN',
  // fallbackLocale: 'en-us',
  messages:{
    'zh-CN': require('../pages/financial/lang/zh'),   // 中文语言包
  }
})

export default ({ app }) => {
  // Set i18n instance on app
  app.i18n = i18n
}

export { i18n }
