import request from '../../utils/request'

/**
 * 重置用户密码信息
 */
export function resetPassword(data) {
    //参数信息AccountType AccountId
    return request({
        url: '/user/ResetUserPassword',
        method: 'post',
        data
    })
}

/**
 * 获取员工列表
 * @param {查询参数} data
 */
export function queryEmployee(data)
{
    return request({
        url: '/user/GetEmployeeList',
        method: 'post',
        data
    })
}

/**
 * 修改离职信息
 * @param {查询参数} data
 */
export function UpdateEmployeeLeave(data)
{
    return request({
        url: '/User/UpdateEmployeeLeaveTime',
        method: 'post',
        data
    })
}

/**
 * 修改部门
 * @param {查询参数} data
 */
export function UpdateEmployeeDept(data)
{
    return request({
        url: '/User/UpdateEmployeeDept',
        method: 'post',
        data
    })
}

/**
 * 修改岗位
 * @param {查询参数} data
 */
export function UpdateEmployeePost(data)
{
    return request({
        url: '/User/UpdateEmployeePost',
        method: 'post',
        data
    })
}

/**
 * 重置密码
 * @param {查询参数} data
 */
export function BatchResetUserPassword(data)
{
    return request({
        url: '/User/BatchResetUserPassword',
        method: 'post',
        data
    })
}
/**
 * 获取部门Id
 */
export function getEmployeeAddrBook(data)
{
  return request({
    url: '/User/GetEmployeeAddrBook',
    method: 'post',
    data
  })
}
