import request from '../../utils/request'

/**
 * 获取课程分页列表
 * @param {JSON参数} data
 */
export function GetClassPageList(data) {
  return request({
    url: '/TeacherClass/GetClassPageList',
    method: 'post',
    data
  })
}

/**
 * 获取课程分页列表
 * @param {JSON参数} data
 */
export function GetClassMonthStatistics(data) {
  return request({
    url: '/TeacherClass/GetClassMonthStatistics',
    method: 'post',
    data
  })
}

/**
 * 获取我的课表分页列表
 * @param {JSON参数} data
 */
export function GetClassPlanStatistical(data) {
  return request({
    url: '/TeacherClass/GetClassPlanStatistical',
    method: 'post',
    data
  })
}

/**
 * 获取我的课表列表数据
 * @param {JSON参数} data
 */
export function GetClassPlanStatisticalPage(data) {
  return request({
    url: '/TeacherClass/GetClassPlanStatisticalPage',
    method: 'post',
    data
  })
}

/**
 * 获取我调课申请列表
 * @param {JSON参数} data
 */
export function GetEducationReceiptPage(data) {
  return request({
    url: '/EducationReceipt/GetEducationReceiptPage',
    method: 'post',
    data
  })
}

/**
 * 获取下拉数据
 * @param {JSON参数} data
 */
export function GetEducationReceiptType() {
  return request({
    url: '/EducationReceipt/GetEducationReceiptType',
    method: 'post'
  })
}

/**
 * 获取下拉数据
 * @param {JSON参数} data
 */
export function GetEduReceiptInfo (data) {
  return request({
    url: '/EducationReceipt/GetEduReceiptInfo ',
    method: 'post',
    data
  })
}

/**
 * 单据作废
 * @param {JSON参数} data
 */
export function invalidReceiptInfo(data) {
  return request({
    url: '/EducationReceipt/InvalidReceipt',
    method: 'post',
    data
  })
}

/**
 * 获取当前单据审核人员
 * @param {JSON参数} data
 */
export function queryCurrentAuditMan(data) {
  return request({
    url: '/EducationReceipt/GetCurrentAuditMan',
    method: 'post',
    data
  })
}

/**
 * 修改当前单据审核人员
 * @param {JSON参数} data
 */
export function saveAuditMan(data) {
  return request({
    url: '/EducationReceipt/EditAuditMan',
    method: 'post',
    data
  })
}
