const routes = [{
  path: "/",
  component: () =>
    import("pages/user/login.vue")
},
{
  path: "/login",
  component: () =>
    import("pages/user/login.vue")
},
{
  path: "/home",
  component: () =>
    import("layouts/MainLayout.vue"),
  children: [{
    path: "",
    component: () =>
      import("src/pages/Work.vue")
  },

  {
    path: "/school/manager",
    component: () =>
      import("pages/school/manager.vue")
  },
  {
    path: "/school/teacher",
    component: () =>
      import("pages/school/teacher.vue")
  },
  {
    path: "/school/assistant",
    component: () =>
      import("pages/school/assistant.vue")
  },
  {
    path: "/school/classroom", //教室管理
    component: () =>
      import("pages/school/classroom.vue")
  },
  {
    path: "/school/student", //学员管理
    component: () =>
      import("pages/school/student.vue")
  },
  {
    path: "/school/sysuser", //后台用户管理
    component: () =>
      import("pages/school/sysuser.vue")
  },
  {
    path: "/school/receiveNumList", //资产的使用列表
    component: () =>
      import("pages/school/receiveNumList.vue")
  },
  {
    path: "/system/menu", //菜单管理
    component: () =>
      import("pages/system/menu.vue")
  },
  {
    path: "/system/noticeSysSet", //公告系统设置
    component: () =>
      import("pages/system/noticeSysSet.vue")
  },
  {
    path: "/system/menufunction", //菜单功能权限管理
    component: () =>
      import("pages/system/menufunction.vue")
  },
  {
    path: "/system/dept", //部门管理
    component: () =>
      import("pages/system/dept.vue")
  },
  {
    path: "/system/deptrelation", //部门关系图
    component: () =>
      import("pages/system/deptrelation.vue")
  },
  {
    path: "/system/post", //岗位管理
    component: () =>
      import("pages/system/post.vue")
  },
  {
    path: "/system/role", //角色管理
    component: () =>
      import("pages/system/role.vue")
  },
  {
    path: "/system/siteconfig", //站点配置
    component: () =>
      import("pages/system/siteconfig.vue")
  },
  {
    path: "/system/msgmanage", //短信管理
    component: () =>
      import("pages/system/msgmanage.vue")
  },
  {
    path: "/system/processSet", //流程配置
    component: () =>
      import("pages/system/processSet.vue")
  },
  {
    path: "/system/okrmanage", //OKR设置
    component: () =>
      import("pages/system/okrmanage.vue")
  },
  {
    path: "/system/webkitManage", //网站管理
    component: () =>
      import("pages/system/webkitManage.vue")
  },
  {
    path: "/system/menuManage", //菜单管理
    component: () =>
      import("pages/system/menuManage.vue")
  },
  {
    path: "/system/newsType", //新闻类型
    component: () =>
      import("pages/system/newsType.vue")
  },
  {
    path: "/system/news", //新闻列表
    component: () =>
      import("pages/system/news.vue")
  },
  {
    path: "/system/teacherManage", //教师团队管理
    component: () =>
      import("pages/system/teacherManage.vue")
  },
  {
    path: "/system/consultManage", //咨询管理
    component: () =>
      import("pages/system/consultManage.vue")
  },
  {
    path: "/system/comicManage", //品牌漫画管理
    component: () =>
      import("pages/system/comicManage.vue")
  },
  {
    path: "/system/monthlyManage", //品牌月刊管理
    component: () =>
      import("pages/system/monthlyManage.vue")
  },
  {
    path: "/system/recruitment", // 招聘管理
    component: () =>
      import("pages/system/recruitment.vue")
  },
  {
    path: "/system/recruitmentType", //招聘类型
    component: () =>
      import("pages/system/recruitmentType.vue")
  },
  {
    path: "/system/jobapplyManage", //招聘申请管理
    component: () =>
      import("pages/system/jobapplyManage.vue")
  },
  {
    path: "/system/dutyManagement", //值班管理
    component: () =>
      import("pages/system/dutyManagement.vue")
  },
  {
    path: "/course/catagory", //课程分类
    component: () =>
      import("pages/course/catagory.vue")
  },
  {
    path: "/course/course", //课程管理
    component: () =>
      import("pages/course/course.vue")
  },
  {
    path: "/course/lessonNotes",  //课程教案
    component: () =>
      import("pages/course/lessonNotes.vue")
  },
  {
    path: "/course/classManage", //班级管理
    component: () =>
      import("pages/course/classManage.vue")
  },
  {
    path: "/course/monthLessonCost", //班级管理 月度课耗
    component: () =>
      import("pages/course/monthLessonCost.vue")
  },
  {
    path: "/course/makeup", //补课管理
    component: () =>
      import("pages/course/makeup.vue")
  },
  {
    path: "/course/baseSet", //基础设置
    component: () =>
      import("pages/course/baseSet.vue")
  },
  {
    path: "/course/classPlan", //上课计划
    component: () =>
      import("pages/course/classPlan.vue")
  },
  {
    path: "/course/paymentDetail", //收支明细
    component: () =>
      import("pages/course/paymentDetail.vue")
  },
  {
    path: "/course/classorder", //班级订单
    component: () =>
      import("pages/course/classorder.vue")
  },
  {
    path: "/course/socialclass", //教学奖励-社会班设置
    component: () =>
      import("pages/course/socialclass.vue")
  },
  {
    path: "/course/studentClass", //教学奖励-学生班设置
    component: () =>
      import("pages/course/studentClass.vue")
  },
  {
    path: "/course/teacherLesson", //教师备课列表
    component: () =>
      import("pages/course/teacherLesson.vue")
  },
  {
    path: "/course/lessonPreparation", //教师备课
    component: () =>
      import("pages/course/lessonPreparation.vue")
  },
  {
    path: "/course/prepareclassDetails", //教师备课 备课详情
    component: () =>
      import("pages/course/prepareclassDetails.vue")
  },
  {
    path: "/financial/PlatformAccount", //平台账户
    component: () =>
      import("pages/financial/PlatformAccount.vue")
  },
  {
    path: "/financial/CompanyAccount", //银行账户
    component: () =>
      import("pages/financial/CompanyAccount.vue")
  },
  {
    path: "/financial/salesRules", //销售提成规则
    component: () =>
      import("pages/financial/salesRules.vue")
  },
  {
    path: "/financial/lessonCostStatistics", //课耗统计汇总表
    component: () =>
      import("pages/financial/lessonCostStatistics.vue")
  },
  {
    path: "/financial/teacherclassfee", //老师课时消费明细列表
    component: () =>
      import("pages/financial/teacherclassfee.vue")
  },
  {
    path: "/financial/saleAchievementsRank", //销售业绩排名统计
    component: () =>
      import("pages/financial/saleAchievementsRank.vue")
  },

  {
    path: "/financial/studentsClassfee", //学生课耗明细列表
    component: () =>
      import("pages/financial/studentsClassfee.vue")
  },
  {
    path: "/financial/salesCommission", //提成周期列表
    component: () =>
      import("pages/financial/salesCommission.vue")
  },
  {
    path: "/financial/CommissionDetail", //周期提成 用户统计列表
    component: () =>
      import("pages/financial/CommissionDetail.vue")
  },
  {
    path: "/financial/userCommissionDetails", //周期提成 用户提成明细
    component: () =>
      import("pages/financial/userCommissionDetails.vue")
  },
  {
    path: "/financial/cycleOrderList", //周期提成  订单提成查询
    component: () =>
      import("pages/financial/cycleOrderList.vue")
  },
  {
    path: "/financial/cycleList", //销售提成统计
    component: () =>
      import("pages/financial/cycleList.vue")
  },

  {
    path: "/financial/TeamRevenueReport", //营收报表
    component: () =>
      import("pages/financial/TeamRevenueReport.vue")
  },
  {
    path: "/financial/EasyReport", //简易报表
    component: () =>
      import("pages/financial/EasyReport.vue")
  },
  {
    path: "/financial/orderCompleteStatistics", //订单完成统计
    component: () =>
      import("pages/financial/orderCompleteStatistics.vue")
  },

  {
    path: "/financial/JumpReport", //单据明细
    component: () =>
      import("pages/financial/JumpReport.vue")
  },
  {
    path: "/financial/institutionsManagement", //金融机构管理
    component: () =>
      import("pages/financial/institutionsManagement.vue")
  },
  {
    path: "/financial/currencyManagement", //币种管理
    component: () =>
      import("pages/financial/currencyManagement.vue")
  },
  {
    path: "/financial/AccountType", //账户类型
    component: () =>
      import("pages/financial/AccountType.vue")
  },
  {
    path: "/financial/AccountPageList", //关联账户
    component: () =>
      import("pages/financial/AccountPageList.vue")
  },
  {
    path: "/financial/CostType", //费用类型
    component: () =>
      import("pages/financial/CostType.vue")
  },
  {
    path: "/financial/paySetting", //支付配置管理
    component: () =>
      import("pages/financial/paySetting.vue")
  },
  {
    path: '/financial/HistoryRateQuery', //历史汇率
    component: () =>
      import("pages/financial/HistoryRateQuery.vue")
  },
  {
    path: "/financial/Maninfo", //未认款信息
    component: () =>
      import("pages/financial/Maninfo.vue")
  },
  {
    path: "/financial/Manfunds", //未认款管理
    component: () =>
      import("pages/financial/Manfunds.vue")
  },
  {
    path: "/financial/HuiChaImport", //汇差批量制单
    component: () =>
      import("pages/financial/HuiChaImport.vue")
  },
  {
    path: "/financial/CashAccount", //汇差批量制单
    component: () =>
      import("pages/financial/CashAccount.vue")
  },
  {
    path: "/financial/sellCommissionRules", //提成规则
    component: () =>
      import("pages/financial/sellCommissionRules.vue")
  },
  {
    path: "/financial/FProcessManagement", //流程管理、
    component: () =>
      import("pages/financial/FProcessManagement.vue")
  },
  {
    path: "/financial/XProcessManagement", //资产流程管理、
    component: () =>
      import("pages/financial/XProcessManagement.vue")
  },
  {
    path: "/financial/addFinancialProcess", //新增修改等级
    component: () =>
      import("pages/financial/addFinancialProcess.vue")
  },
  {
    path: "/financial/XaddFinancialProcess", //新增修改资产流程
    component: () =>
      import("pages/financial/XaddFinancialProcess.vue")
  },
  {
    path: "/financial/accountingWork", //会计窗口
    component: () =>
      import("pages/financial/accountingWork.vue")
  },
  {
    path: "/financial/CashierWork", //出纳窗口
    component: () =>
      import("pages/financial/CashierWork.vue")
  },
  {
    path: "/financial/empBankAccount", //常用付款对象
    component: () =>
      import("pages/financial/empBankAccount.vue")
  },
  {
    path: "/financial/accDetail/CashAccDetail", //现金账户明细
    component: () =>
      import("pages/financial/accDetail/CashAccDetail.vue")
  },
  {
    path: "/financial/accDetail/CompanyAccDetail", //银行账户明细
    component: () =>
      import("pages/financial/accDetail/CompanyAccDetail.vue")
  },
  {
    path: "/financial/accDetail/PlatformAccDetail", //平台账户明细
    component: () =>
      import("pages/financial/accDetail/PlatformAccDetail.vue")
  },
  {
    path: "/financial/accDetail/TransferReport", //银行日报表
    component: () =>
      import("pages/financial/accDetail/TransferReport.vue")
  },
  {
    path: "/financial/accDetail/newTransferReport", //新银行日报表
    component: () =>
      import("pages/financial/accDetail/newTransferReport.vue")
  },
  {
    path: "/financial/accDetail/CashReport", //现金日报表
    component: () =>
      import("pages/financial/accDetail/CashReport.vue")
  }, {
    path: "/financial/accDetail/newCashReport", //新现金日报表
    component: () =>
      import("pages/financial/accDetail/newCashReport.vue")
  },
  {
    path: "/financial/financalDocument/ChoiceAddFinancialDocuments",
    component: () =>
      import("pages/financial/financalDocument/ChoiceAddFinancialDocuments.vue")
  },
  {
    path: "/financial/financalDocument/addReceivablesDocuments",
    component: () =>
      import("pages/financial/financalDocument/addReceivablesDocuments.vue")
  },
  {
    path: "/financial/financalDocument/invoicesManager", //发票管理
    component: () =>
      import("pages/financial/financalDocument/invoicesManager.vue")
  },
  {
    path: "/financial/financalDocument/refundQuery", //发票管理
    component: () =>
      import("pages/financial/financalDocument/refundQuery.vue")
  },
  {
    path: "/financial/financalDocument/CapitalAllocation", //资金调拨
    component: () =>
      import("pages/financial/financalDocument/CapitalAllocation.vue")
  },
  {
    path: "/financial/financalDocument/addCapitalAllocation", //资金调拨 新增
    component: () =>
      import("pages/financial/financalDocument/addCapitalAllocation.vue")
  },
  {
    path: "/financial/financalDocument/RecPayQuery", //收支查询
    component: () =>
      import("pages/financial/financalDocument/RecPayQuery.vue")
  },
  {
    path: "/financial/financalDocument/FinancialDocuments", //我的财务单据
    component: () =>
      import("pages/financial/financalDocument/FinancialDocuments.vue")
  },
  {
    path: "/financial/financalDocument/GetWOrkTransferPageLis", //员工财务单据转交
    component: () =>
      import("pages/financial/financalDocument/GetWOrkTransferPageLis.vue")
  },
  {
    path: "/financial/financalDocument/WorkEntrustmentMy", //工作委托
    component: () =>
      import("pages/financial/financalDocument/WorkEntrustmentMy.vue")
  },
  {
    path: "/financial/financalDocument/CapitalAllocationDetail", //资金调拨单 详情
    component: () =>
      import("pages/financial/financalDocument/CapitalAllocationDetail.vue")
  },
  {
    path: "/financial/financalDocument/addFinancialDocuments", //新增财务单据
    component: () =>
      import("pages/financial/financalDocument/addFinancialDocuments.vue")
  },
  {
    path: "/financial/financalDocument/FinancialDocumentsDetail", //我的财务单据详情
    component: () =>
      import("pages/financial/financalDocument/FinancialDocumentsDetail.vue")
  },
  {
    path: "/financial/financalDocument/PropertyProcurementDetails", //资产采购详情
    component: () =>
      import("pages/financial/financalDocument/PropertyProcurementDetails.vue")
  },
  {
    path: "/financial/financalDocument/SuppliesProcurementDetail", //耗材采购详情
    component: () =>
      import("pages/financial/financalDocument/SuppliesProcurementDetail.vue")
  },
  {
    path: "/financial/financalDocument/InAndOutDdetails", //财务单据 教育耗材出库
    component: () =>
      import("pages/financial/financalDocument/InAndOutDdetails.vue")
  },


  {
    path: "/financial/financalDocument/BasicDocuments", //财务 财务单据 审核标准单据
    component: () =>
      import("pages/financial/financalDocument/BasicDocuments.vue")
  },
  {
    path: "/financial/reportform/RecPayQueryTeam", //财务报表 月度班级收支统计
    component: () =>
      import("pages/financial/reportform/RecPayQueryTeam.vue")
  },
  {
    path: "/financial/reportform/RevenueFileMan", //财务报表 营收文件管理
    component: () =>
      import("pages/financial/reportform/RevenueFileMan.vue")
  },
  {
    path: "/financial/reportform/settleAccounts", //财务报表 财务轧账月份列表
    component: () =>
      import("pages/financial/reportform/settleAccounts.vue")
  },
  {
    path: "/financial/reportform/activityDeploy", //财务流程 获取活动配置
    component: () =>
      import("pages/financial/reportform/activityDeploy.vue")
  },
  
  {
    path: "/administration/document", //行政公告
    component: () =>
      import("pages/administration/document.vue")
  },
  {
    path: "/administration/documentApproval", //行政公告审批
    component: () =>
      import("pages/administration/documentApproval.vue")
  },
  {
    path: "/administration/Approval", //行政审批
    component: () =>
      import("pages/administration/Approval.vue")
  },
  {
    path: "/administration/ApprovalProcess", //审批流程详情
    component: () =>
      import("pages/administration/ApprovalProcess.vue")
  },
  {
    path: "/administration/processDesign", //分条件审批
    component: () =>
      import("pages/administration/processDesign.vue")
  },
  {
    path: "/administration/updateProcessDesign", //分条件审批
    component: () =>
      import("pages/administration/updateProcessDesign.vue")
  },
  {
    path: "/administration/myApprovalList", //我的审批
    component: () =>
      import("pages/administration/myApprovalList.vue")
  },
  {
    path: "/administration/myApproval", //我的发起
    component: () =>
      import("pages/administration/myApproval.vue")
  }, {
    path: "/administration/forMyApproval", //我的审批
    component: () =>
      import("pages/administration/forMyApproval.vue")
  },
  {
    path: "/administration/ApprovalStatistical", //审批统计
    component: () =>
      import("pages/administration/ApprovalStatistical.vue")
  },
  {
    path: "/administration/sendToMeApproval", //抄送
    component: () =>
      import("pages/administration/sendToMeApproval.vue")
  },
  {
    path: "/administration/leaveApproval", //请假
    component: () =>
      import("pages/administration/leaveApproval.vue")
  },
  {
    path: "/administration/Attendance", //考勤管理
    component: () =>
      import("pages/administration/Attendance.vue")
  },
  {
    path: "/administration/AttendanceRules", //考勤设置
    component: () =>
      import("pages/administration/AttendanceRules.vue")
  },
  {
    path: "/administration/outWorkApproval", //外勤考勤
    component: () =>
      import("pages/administration/outWorkApproval.vue")
  },
  {
    path: "/sale/japaneseTrain", //日语培训列表
    component: () =>
      import("pages/sale/japaneseTrain.vue")
  },
  {
    path: "/sale/courseList", //销售 课程预览
    component: () =>
      import("pages/sale/courseList.vue")
  },
  {
    path: "/sale/studyjob", //留学就业产品
    component: () =>
      import("pages/sale/studyjob.vue")
  },
  {
    path: "/sale/courseoffer", //销售 报价单管理
    component: () =>
      import("pages/sale/courseoffer.vue")
  },
  {
    path: "/sale/myoffer", //销售 我的报价单
    component: () =>
      import("pages/sale/myoffer.vue")
  },
  {
    path: "/sale/myOrder", //销售 我的订单
    component: () =>
      import("pages/sale/myOrder.vue")
  },
  {
    path: "/sale/orderStatistics", //销售 报名统计
    component: () =>
      import("pages/sale/orderStatistics.vue")
  },
  {
    path: "/sale/studyOrder", //销售 我的留学就业订单
    component: () =>
      import("pages/sale/studyOrder.vue")
  },
  {
    path: "/sale/studyOrderStatistics", //销售 我的留学就业订单统计
    component: () =>
      import("pages/sale/studyOrderStatistics.vue")
  },
  {
    path: "/sale/SuppliesStockOutApplyForMan", //销售 出库管理
    component: () =>
      import("pages/sale/SuppliesStockOutApplyForMan.vue")
  },
  {
    path: "/sale/SuppliesStockOutApplyForDetail", //销售 出库管理详情
    component: () =>
      import("pages/sale/SuppliesStockOutApplyForDetail.vue")
  },
  {
    path: "/sale/contractManage", //销售 合同管理
    component: () =>
      import("pages/sale/contractManage.vue")
  },
  {
    path: "/sale/contractEdit", //销售 新增-编辑-查看合同
    component: () =>
      import("pages/sale/contractEdit.vue")
  },
  {
    path: "/sale/contractAudit", //销售 合同审核
    component: () =>
      import("pages/sale/contractAudit.vue")
  },
  {
    path: "/sale/studentList", //销售 学生名单
    component: () =>
      import("pages/sale/studentList.vue")
  },
  {
    path: "/sale/visitorRegistrat", //销售 访客登记
    component: () =>
      import("pages/sale/visitorRegistrat.vue")
  },
  {
    path: "/sale/activityList", //销售 活动列表
    component: () =>
      import("pages/sale/activityList.vue")
  },
  {
    path: "/sale/activeOrderList", //销售 活动订单中心
    component: () =>
      import("pages/sale/activeOrderList.vue")
  },
  {
    path: "/sale/myActiveOrder", //销售 我的活动订单
    component: () =>
      import("pages/sale/myActiveOrder.vue")
  },
  {
    path: "/sale/activeOrderStatistics", //销售 活动订单统计
    component: () =>
      import("pages/sale/activeOrderStatistics.vue")
  },
  {
    path: "/activity/activeType", //活动 活动类型
    component: () =>
      import("pages/activity/activeType.vue")
  },
  {
    path: "/activity/activityList", //活动 活动列表
    component: () =>
      import("pages/activity/activityList.vue")
  },
  {
    path: "/activity/activeSignUpList", //活动 活动报名列表
    component: () =>
      import("pages/activity/activeSignUpList.vue")
  },
  {
    path: "/activity/activeSignUpList2", //活动 活动报名列表type2
    component: () =>
      import("pages/activity/activeSignUpList2.vue")
  },
  {
    path: "/activity/activeSummary", //活动 活动总结
    component: () =>
      import("pages/activity/activeSummary.vue")
  },
  {
    path: "/activity/materialMan", //活动 活动图片与视频
    component: () =>
      import("pages/activity/materialMan.vue")
  },
  {
    path: "/activity/payment", //活动 活动收支
    component: () =>
      import("pages/activity/payment.vue")
  },
  {
    path: "/activity/activeDetail", //活动 活动详情
    component: () =>
      import("pages/activity/activeDetail.vue")
  },
  {
    path: "/activity/copyActive", //活动 复制活动
    component: () =>
      import("pages/activity/copyActive.vue")
  },
  {
    path: "/activity/advmanager", //活动 广告图管理
    component: () =>
      import("pages/activity/advmanager.vue")
  },
  {
    path: "/activity/makeAd", //活动 制作广告图
    component: () =>
      import("pages/activity/makeAd.vue")
  },
  {
    path: "/activity/myadvert", //活动 我的广告图
    component: () =>
      import("pages/activity/myadvert.vue")
  },
  {
    path: "/sale/appointManagement", //销售 约课管理
    component: () =>
      import("pages/sale/appointManagement.vue")
  },
  {
    path: "/sale/reserveClass", //销售 约课班级管理
    component: () =>
      import("pages/sale/reserveClass.vue")
  },
  {
    path: "/sale/reserveStudentList", //销售 约课班级学员名单
    component: () =>
      import("pages/sale/reserveStudentList.vue")
  },
  {
    path: "/course/teacherHours", //教学奖励 教师课时统计
    component: () =>
      import("pages/course/teacherHours.vue")
  },
  {
    path: "/course/classHourReward", //教学奖励 课时奖励
    component: () =>
      import("pages/course/classHourReward.vue")
  },
  {
    path: "/course/classHourStatistic", //教学奖励 课时统计
    component: () =>
      import("pages/course/classHourStatistic.vue")
  },
  {
    path: "/course/rewardDetailed", //教学奖励 奖励明细
    component: () =>
      import("pages/course/rewardDetailed.vue")
  },
  {
    path: "/course/achievements", //教学奖励 绩效列表
    component: () =>
      import("pages/course/achievements.vue")
  },
  {
    path: "/user/backbill", //退课单据
    component: () =>
      import("pages/user/backbill.vue")
  },
  {
    path: "/user/billquery", //单据查询
    component: () =>
      import("pages/user/billquery.vue")
  },
  {
    path: "/user/personalData", //个人资料
    component: () =>
      import("pages/user/personalData.vue")
  },

  {
    path: "/course/questionlist", //题库列表
    component: () =>
      import("pages/course/questionlist.vue")
  },
  {
    path: "/course/question", //题库列表
    component: () =>
      import("pages/course/question.vue")
  },
  {
    path: "/course/questionInfo", //题库详情
    component: () =>
      import("pages/course/questionInfo.vue")
  },
  {
    path: "/sale/quotation", //报价单
    component: () =>
      import("pages/sale/quotation.vue")
  },
  {
    path: "/course/courseinfo",
    component: () => import("pages/course/courseinfo.vue"),
    children: [{
      path: "/course/teachplan", //教案管理
      component: () =>
        import("pages/course/teachplan.vue")
    },
    {
      path: "/course/chapter", //章节管理
      component: () =>
        import("pages/course/chapter.vue")
    },

    {
      path: "/course/coursejob", //作业管理
      component: () =>
        import("pages/course/coursejob.vue")
    },

    ]
  },
  {
    path: "/course/jobinfo", //作业详情管理
    component: () =>
      import("pages/course/jobinfo.vue")
  },
  {
    path: "/studyAbroad/studyabroad", //留学
    component: () =>
      import("pages/studyAbroad/studyabroad.vue")
  },
  {
    path: "/studyAbroad/employment", //就业
    component: () =>
      import("pages/studyAbroad/employment.vue")
  },
  {
    path: "/studyAbroad/studyemploymentorder", //留学就业订单中心
    component: () =>
      import("pages/studyAbroad/studyemploymentorder.vue")
  },
  {
    path: "/studyAbroad/studypayment", //留学就业收支明细
    component: () =>
      import("pages/studyAbroad/studypayment.vue")
  },
  {
    path: "/studyAbroad/supplier", //供应商
    component: () =>
      import("pages/studyAbroad/supplier.vue")
  },
  {
    path: "/studyAbroad/studyProAudit", //留学产品审核
    component: () =>
      import("pages/studyAbroad/studyProAudit.vue")
  },
  {
    path: "/scheduling/schedulingPlan", //排班计划
    component: () =>
      import("pages/scheduling/schedulingPlan.vue")
  },
  {
    path: "/scheduling/schedulingRecord", //值班记录
    component: () =>
      import("pages/scheduling/schedulingRecord.vue")
  },
  {
    path: "/scheduling/schedulDetail", //我的工作计划排班详情
    component: () =>
      import("pages/scheduling/schedulDetail.vue")
  },
  {
    path: "/scheduling/scheduleBoard", //值班看板
    component: () =>
      import("pages/scheduling/scheduleBoard.vue")
  },
  {
    path: "/scheduling/scheduleInfo", //值班详情
    component: () =>
      import("pages/scheduling/scheduleInfo.vue")
  },
  {
    path: "/scheduling/vacationPlan", //假期计划表
    component: () =>
      import("pages/scheduling/vacationPlan")
  },
  {
    path: "/test", //API测试
    component: () =>
      import("pages/test.vue")
  },
  {
    path: "/classroom/Scheduling", //教室状态
    component: () =>
      import("pages/classroom/Scheduling")
  },
  {
    path: "/classroom/useRecord", //教室使用记录
    component: () =>
      import("pages/classroom/useRecord")
  },
  {
    path: "/classroom/courseInfo", //教室本次上课信息
    component: () =>
      import("pages/classroom/courseInfo")
  },
  {
    path: "/teacher/myClass", //我的班级
    component: () =>
      import("pages/teacher/myClass")
  },
  {
    path: "/teacher/testdatabase", //题库查询
    component: () =>
      import("pages/teacher/testdatabase")
  },
  {
    path: "/teacher/relation-order", //关联订单
    component: () =>
      import("pages/teacher/relationOrder")
  },
  {
    path: "/teacher/change-class-manager", //关联订单
    component: () =>
      import("pages/teacher/changeClassManager")
  },
  {
    path: "/teacher/teachMonthLessonCost", //月度课耗
    component: () =>
      import("pages/teacher/teachMonthLessonCost")
  },
  {
    path: "/teacher/myPrepareLessons", //我的备课
    component: () =>
      import("pages/teacher/myPrepareLessons")
  },
  {
    path: "/teacher/lessonTimeStatistics", //课时统计
    component: () =>
      import("pages/teacher/lessonTimeStatistics")
  },
  {
    path: "/teacher/teacherclassSee", //课时统计-查看老师
    component: () =>
      import("pages/teacher/teacherclassSee")
  },
  {
    path: "/teacher/studentsClassSee", //课时统计-查看学生
    component: () =>
      import("pages/teacher/studentsClassSee")
  },
  {
    path: "/teacher/studentManager", //学员管理
    component: () =>
      import("pages/teacher/studentManager")
  }, {
    path: "/teacher/teacherSchedule",
    component: () =>
      import("pages/teacher/teacherSchedule")
  }, {
    path: "/stuMan/activeList",//学管   活动列表
    component: () =>
      import("pages/stuMan/activeList")
  },
  {
    path: "/stuMan/classPlan",//学管   上课计划
    component: () =>
      import("pages/stuMan/classPlan")
  },
  {
    path: "/stuMan/classRecord",//学管   上课记录
    component: () =>
      import("pages/stuMan/classRecord")
  },
  {
    path: "/stuMan/studentManage",//学管  学员管理
    component: () =>
      import("pages/stuMan/studentManage")
  },
  {
    path: "/stuMan/stuList",//学管  学员名单
    component: () =>
      import("pages/stuMan/stuList")
  }, {
    path: "/stuMan/visitorRecord",//学管  访问管理
    component: () =>
      import("pages/stuMan/visitorRecord")
  },
  {
    path: "/stuMan/todaysOrder",//学管  今日订单
    component: () =>
      import("pages/stuMan/todaysOrder")
  },
  ],

},
// Always leave this as last one,
// but you can also remove it
{
  path: "/contractConfirm",
  component: () =>
    import("pages/contractConfirm.vue")
},
{
  path: '/contractSign',  //合同签名页面
  component: () =>
    import("pages/contractSign.vue")
},
{
  path: "/contractPay",
  component: () =>
    import("pages/contractPay.vue")
},
//公告预览
{
  path: "/noticeView",
  component: () =>
    import("pages/noticeView.vue")
},
{
  path: "/contractView",
  component: () =>
    import("pages/contractView.vue")
},
{
  path: "/financial/financalDocument/PrintPage", //财务单据打印
  component: () =>
    import("pages/financial/financalDocument/PrintPage.vue")
},
{
  path: "/financial/financalDocument/PrintPageN", //财务凭证打印
  component: () =>
    import("pages/financial/financalDocument/PrintPageN.vue")
},


{
  path: '/AssetsShenpi', //资产管理审批
  name: 'AssetsShenpi',
  component: () => import('pages/administration/AssetsSystem/AssetsShenpi'),
  meta: {
    title: '资产管理'
  },
},
{
  path: '/RequisitionShenpi', //资产管理审批
  name: 'RequisitionShenpi',
  component: () => import('pages/administration/AssetsSystem/RequisitionShenpi'),
  meta: {
    title: '资产管理'
  },
},
{
  path: "/course/chapter-editor", //章节管理
  component: () =>
    import("pages/course/chapterEditor.vue")
},
{
  path: "*",
  component: () =>
    import("pages/Error404.vue")
}
];

export default routes;
