import request from '../../utils/request'

/**
 * 获取课程分页列表
 * @param {JSON参数} data 
 */
export function queryCourseCategoryPage(data) {
  return request({
    url: '/Course/GetCourseCategoryPageList',
    method: 'post',
    data
  })
}

/**
 * 获取课程分类树形列表
 */
export function queryCourseCategoryTree(data) {
  return request({
    url: '/Course/GetCourseCategoryTree',
    method: 'post',
    data
  })
}

/**
 * 根据编号获取课程分类信息
 */
export function queryCourseCategoryInfo(data) {
  return request({
    url: '/Course/GetCourseCategory',
    method: 'post',
    data
  })
}

/**
 * 保存课程分类
 * @param {JSON参数} data 
 */
export function saveCourseCategoryInfo(data) {
  return request({
    url: '/Course/SetCourseCategory',
    method: 'post',
    data
  })
}

/**
 * 删除课程分类
 * @param {JOSN参数} data 
 */
export function deleteCourseCategory(data) {
  return request({
    url: '/Course/RemoveCourseCategory',
    method: 'post',
    data
  })

}

/**
 * 获取课程分页列表
 * @param {JSON参数} data 
 */
export function queryCoursePage(data) {
  return request({
    url: '/Course/GetCoursePageList',
    method: 'post',
    data
  })
}


/**
 * 获取课程下拉列表
 * @param {JSON对象} data 
 */
export function queryCourseDropdownList(data) {
  return request({
    url: '/Course/GetCourseList',
    method: 'post',
    data
  })
}

/**
 * 获取课程详情
 * @param {JSON参数} data 
 */
export function queryCourseInfo(data) {
  return request({
    url: '/Course/GetCourse',
    method: 'post',
    data
  })
}

/**
 * 保存课程详情
 */
export function saveCourseInfo(data) {
  return request({
    url: '/Course/SetCourse',
    method: 'post',
    data
  })
}

/**
 * 删除课程详情
 * @param {JSON对象} data 
 */
export function deleteCourseInfo(data) {
  return request({
    url: '/Course/RemoveCourse',
    method: 'post',
    data
  })
}


/**
 * 设置是否显示课程章节
 * @param {JSON对象} data 
 */
export function updateCourseIsShowChapterNo(data) {
  return request({
    url: "/Course/SetCourseIsShowChapterNo",
    method: 'post',
    data
  })
}

/**
 * 设置课程教师
 * @param {JSON参数} data 
 */
export function updateCourseTeacher(data) {
  return request({
    url: "/Course/SetCourseTeacher",
    method: 'post',
    data
  })
}

/**
 * 获取课程教案分页
 * @param {JSON对象} data 
 */
export function queryTeachPlanPage(data) {
  return request({
    url: "/Course/GetCourseTeachPlanPage",
    method: 'post',
    data
  })
}

/**
 * 获取课程教案信息
 */
export function queryTeachPlanInfo(data) {
  return request({
    url: "/Course/GetTeachPlan",
    method: 'post',
    data
  })
}

/**
 * 保存课程教案
 * @param {JSON数据} data 
 */
export function saveTeachPlanInfo(data) {
  return request({
    url: "/Course/SetTeachPlan",
    method: 'post',
    data
  })
}

/**
 * 删除课程教案
 * @param {JSON参数} data 
 */
export function removeTeachPlanInfo(data) {
  return request({
    url: "/Course/RemoveTeachPlan",
    method: 'post',
    data
  })
}

/**
 * 获取课程章节树形列表
 * @param {JSON参数} data 
 */
export function queryChapterTree(data) {
  return request({
    url: "/Course/GetChapterTree",
    method: 'post',
    data
  })
}

/**
 * 保存课程章节
 * @param {JSON参数} data 
 */
export function saveChapter(data) {
  return request({
    url: "/Course/SetChapter",
    method: 'post',
    data
  })
}

/**
 * 保存课程章节
 * @param {JSON参数} data 
 */
 export function getCourseRate(data) {
  return request({
    url: "/Course/GetCourseRateEnumList",
    method: 'post',
    data
  })
}

/**
 * 保存课程章节
 * @param {JSON参数} data 
 */
 export function deleteChapters(data) {
  return request({
    url: "/Course/BatchRemoveChapter",
    method: 'post',
    data
  })
}

/**
 * 保存课程章节
 * @param {JSON参数} data 
 */
 export function setChaptersRate(data) {
  return request({
    url: "/Course/BatchSetChapterRate",
    method: 'post',
    data
  })
}

/**
 * 批量更新章节编号和ID
 * @param {JSON参数} data 
 */
 export function batchUpdateChapterNo(data) {
  return request({
    url: "/Course/SetBatchChapterNo",
    method: 'post',
    data
  })
}

/**
 * 修改章节名称
 * @param {JSON参数} data 
 */
 export function updateChapterName(data) {
  return request({
    url: "/Course/SetChapterName",
    method: 'post',
    data
  })
}

/**
 * 获取课程销售端口
 */
export function querySaleplatList() {
  return request({
    url: "/Course/GetSaleplatList",
    method: 'post',
    data: {}
  })
}

/**
 * 新增修改课程作业
 */
export function SaveCourseJobInfo(data) {
  return request({
    url: "/Course/SetCourseJob",
    method: 'post',
    data
  })
}

/**
 * 获取课程作业分页列表
 */
export function queryCourseJobPageList(data) {
  return request({
    url: "/Course/GetCourseJobPageList",
    method: 'post',
    data
  })
}


/**
 * 获取课程优惠类型列表
 */
export function queryCoursePreferentialType() {
  return request({
    url: "/Course/GetCoursePreferentialType",
    method: 'post',
  })
}

/**
 * 获取课程优惠列表
 */
export function queryCoursePreferentialList(data) {
  return request({
    url: "/Course/GetCoursePreferentialList",
    method: 'post',
    data
  })
}

/**
 * 新增修改课程优惠
 */
export function saveCoursePreferential(data) {
  return request({
    url: "/Course/SetBeatchCoursePreferential",
    method: 'post',
    data
  })
}

/**
 * 新增修改报价单
 */
export function saveCourseOffer(data) {
  return request({
    url: "/CourseOffer/SetCourseOffer",
    method: 'post',
    data
  })
}

/**
 * 获取课程报价列表
 */
export function queryCourseOfferPage(data) {
  return request({
    url: "/CourseOffer/GetCourseOfferPage",
    method: 'post',
    data
  })
}


/**
 * 获取报价单详情
 */
export function queryCourseOfferInfo(data) {
  return request({
    url: "/CourseOffer/GetCourseOffer",
    method: 'post',
    data
  })
}

/**
 * 设置报价单状态
 */
export function saveCourseOfferCustomerStatus(data) {
  return request({
    url: "/CourseOffer/SetCourseOfferCustomerStatus",
    method: 'post',
    data
  })
}


/**
 * 报价单转订单
 */
export function saveOfferToOrder(data) {
    return request({
      url: "/CourseOffer/OfferTransOrder",
      method: 'post',
      data
    })
  }

/**
 * 报价单申请改价
 */
export function SetApplyModifyPrice(data) {
    return request({
      url: "/CourseOffer/SetApplyModifyPrice",
      method: 'post',
      data
    })
}

/**
 * 报价单修改价格
 */
export function saveCourseOfferPrice(data) {
  return request({
    url: "/CourseOffer/SetCourseOfferPrice",
    method: 'post',
    data
  })
}


/**
 * 获取公告弹窗数据
 */
export function GetMyNoticePageList(data) {
  return request({
    url: "/UserCenter/GetMyNoticePageList",
    method: 'post',
    data
  })
}

/**
 * 获取公告弹窗详情
 */
export function GetNoticeInfo(data) {
  return request({
    url: "/UserCenter/GetNoticeInfo",
    method: 'post',
    data
  })
}

/**
 *  修改弹窗公告状态
 */
export function SetNoticeOperation(data) {
  return request({
    url: "/UserCenter/SetNoticeOperation",
    method: 'post',
    data
  })
}

/**
 *  获取日志列表
 */
export function GetMsgLogList() {
  return request({
    url: "/Public/GetMsgLogList",
    method: 'post'
  })
}

/**
 *  看过后删除推送
 */
export function BeatchReadMsgLog(data) {
  return request({
    url: "/Public/BeatchReadMsgLog",
    method: 'post',
    data
  })
}

/**
 * 新增修改班级课程
 * @param {JSON对象} data 
 */
export function setClassCourse(data) {
  return request({
    url: '/Class/SetClassCourse',
    method: 'post',
    data
  })
}

/**
 * 获取班级关联课程列表
 * @param {JSON对象} data 
 */
export function queryClassCourseList(data) {
  return request({
    url: '/Class/GetClassCourseList',
    method: 'post',
    data
  })
}

/**
 * 获取班级关联课程列表
 * @param {JSON对象} data 
 */
export function deleteClassCourse(data) {
  return request({
    url: '/Class/RemoveClassCourse',
    method: 'post',
    data
  })
}


/**
 * 获取章节导入选择
 * @param {JSON对象} data 
 */
export function GetCourseChaperDate(data) {
  return request({
    url: '/course/GetAllCourseChapterCount',
    method: 'post',
    data
  })
}

/**
 * 保存选择 以导入
 * @param {JSON对象} data 
 */
export function SetImportCourse(data) {
  return request({
    url: '/course/SetImportCourseChapter',
    method: 'post',
    data
  })
}



 