import request from '../../utils/request'

/**
 * 获取班次分页列表
 * @param {JSON参数} data 
 */
export function qyeryDutyFrequencyPage(data) {
  return request({
    url: '/Duty/GetDutyFrequencyPage',
    method: 'post',
    data
  })
}

/**
 * 获取班次列表
 * @param {JSON参数} data 
 */
export function getDutyFrequencyList(data) {
  return request({
    url: '/Duty/GetDutyFrequencyList',
    method: 'post',
    data
  })
}

/**
 * 删除班次
 * @param {JSON参数} data 
 */
export function removeFrequency(data) {
  return request({
    url: '/Duty/RemoveFrequency',
    method: 'post',
    data
  })
}

/**
 * 新增修改班次
 * @param {JSON参数} data 
 */
export function SetFrequency(data) {
  return request({
    url: '/Duty/GetSetFrequency',
    method: 'post',
    data
  })
}

/**
 * 值班事项列表
 * @param {JSON参数} data 
 */
export function queryDutyItemPage(data) {
  return request({
    url: '/Duty/GetDutyItemPage',
    method: 'post',
    data
  })
}

/**
 * 删除值班事项列表
 * @param {JSON参数} data 
 */
export function removeDutyItem(data) {
  return request({
    url: '/Duty/RemoveDutyItem',
    method: 'post',
    data
  })
}

/**
 * 值班事项类型枚举
 * @param {JSON参数} data 
 */
export function getItemTypeEnumList(data) {
  return request({
    url: '/Duty/GetItemTypeEnumList',
    method: 'post',
    data
  })
}

/**
 * 新增/修改值班事项
 * @param {JSON参数} data 
 */
export function saveDutyItem(data) {
  return request({
    url: '/Duty/SetDutyItem',
    method: 'post',
    data
  })
}

/**
 * 根据编号值班事项信息
 * @param {JSON参数} data 
 */
export function queryDutyItemInfo(data) {
  return request({
    url: '/Duty/GetDutyItem',
    method: 'post',
    data
  })
}


/**
 * 根据班次获取学校信息
 * @param {JSON参数} data 
 */
export function getSchoolListByFrequencyIds(data) {
  return request({
    url: '/Duty/GetSchoolListByFrequencyIds',
    method: 'post',
    data
  })
}

/**
 * 根据学校id获取对应的班次
 * @param {JSON参数} data 
 */
export function getDutyFrequencyBySchoolIds(data) {
  return request({
    url: '/Duty/GetDutyFrequencyBySchoolIds',
    method: 'post',
    data
  })
}

/**
 * 获取值班设置列表
 * @param {JSON参数} data 
 */
export function getDutyConfigList(data) {
  return request({
    url: '/Duty/GetDutyConfigList',
    method: 'post',
    data
  })
}

/**
 * 新增/修改值班设置
 * @param {JSON参数} data 
 */
export function saveDutyConfig(data) {
  return request({
    url: '/Duty/SetDutyConfig',
    method: 'post',
    data
  })
}

/**
 * 删除值班设置
 * @param {JSON参数} data 
 */
export function removeDutyConfig(data) {
  return request({
    url: '/Duty/RemoveDutyConfig',
    method: 'post',
    data
  })
}
