import request from '../../utils/request'
import request_zc from '../../utils/request_zc'

/**
 * 获取收支明细数据
 *
 */
export function GetClassBalanceSheet(data) {
  return request({
    url: '/Finance/GetClassBalanceSheet',
    method: 'post',
    data
  })
}
/**
 * 根据 班级ids 获取班级信息
 *
 */
export function getClassNameList(data) {
  return request({
    url: '/order/GetClassNameList',
    method: 'post',
    data
  })
}

/**
 * 根据 留学就业ids 获取留学就业信息
 *
 */
export function queryStudyNameList(data) {
  return request({
    url: '/order/GetStudyNameList',
    method: 'post',
    data
  })
}

/**
 *获取简易报表数据
 */
export function getEasyReportList(data) {
  return request({
    url: '/finance/GetEasyReportList',
    method: 'post',
    data
  })
}
// 财务单据 资产采购详情
export function getPropertyProcurementInfo(data) {
  return request_zc({
    url: '/property/GetPropertyProcurementInfo',
    method: 'post',
    data
  });
}
// 财务单据 耗材采购详情
export function getSuppliesProcurementInfo(data) {
  return request_zc({
    url: '/supplies/GetSuppliesProcurementInfo',
    method: 'post',
    data
  });
}
// 财务单据 教育出库详情
export function getStockOutPageList(data) {
  return request_zc({
    url: '/Warehouse/GetStockOutPageList',
    method: 'post',
    data
  });
}
// 财务流程 销售提成规则
export function getSellCommissionRuleList(data) {
  return request({
    url: '/SellCommission/GetSellCommissionRuleList',
    method: 'post',
    data
  });
}

// 财务流程 保存销售提成规则
export function setSellCommissionRule(data) {
  return request({
    url: '/SellCommission/SetSellCommissionRule',
    method: 'post',
    data
  });
}
// 财务工作台 获取提成周期列表
export function getSellCommissionPeriodsPageList(data) {
  return request({
    url: '/SellCommission/GetSellCommissionPeriodsPageList',
    method: 'post',
    data
  });
}
// 财务工作台 获取周期提成 用户统计列表
export function getSellCommissionUserList(data) {
  return request({
    url: '/SellCommission/GetSellCommissionUserList',
    method: 'post',
    data
  });
}
// 财务工作台 获取周期提成 用户统计列表
export function getSellCommissionUserDetailList(data) {
  return request({
    url: '/SellCommission/GetSellCommissionUserDetailList',
    method: 'post',
    data
  });
}
// 财务工作台 获取周期提成 用户统计列表
export function getSellCommissionForOrderList(data) {
  return request({
    url: '/SellCommission/GetSellCommissionForOrderList',
    method: 'post',
    data
  });
}

// 财务工作台 获取周期提成 创建提成
export function setSellCommissionInfo(data) {
  return request({
    url: '/SellCommission/SetSellCommissionInfo',
    method: 'post',
    data
  });
}

// 财务工作台 获取周期提成  提成统计
export function getSellCommissionStatistics(data) {
  return request({
    url: '/SellCommission/GetSellCommissionStatistics',
    method: 'post',
    data
  });
}

// 财务工作台 获取周期提成  周期列表下拉选择
export function getSellCommissionPeriodsList(data) {
  return request({
    url: '/SellCommission/GetSellCommissionPeriodsList',
    method: 'post',
    data
  });
}

// 财务报表 获取老师课耗统计
export function getTeacherConsumptionHoursStatistics(data) {
  return request({
    url: '/finance/GetTeacherConsumptionHoursStatistics',
    method: 'post',
    data
  });
}


// 财务报表 获取老师课时消费明细列表
export function getTeacherConsumptionHoursDetialPageList(data) {
  return request({
    url: '/finance/GetTeacherConsumptionHoursDetialPageList',
    method: 'post',
    data
  });
}

// 财务报表 学生课耗明细列表
export function getStudentConsumptionHoursDetialPageList(data) {
  return request({
    url: '/finance/GetStudentConsumptionHoursDetialPageList',
    method: 'post',
    data
  });
}

// 财务报表 销售业绩排名统计
export function getSaleAchievementsRankStatistics(data) {
  return request({
    url: '/finance/GetSaleAchievementsRankStatistics',
    method: 'post',
    data
  });
}

//  获取可发放提成的用户
export function getSellCommissionSendEmployeeList(data) {
  return request({
    url: '/SellCommission/GetSellCommissionSendEmployeeList',
    method: 'post',
    data
  });
}

//  设置用户已发
export function setSellCommissionSendEmployee(data) {
  return request({
    url: '/SellCommission/SetSellCommissionSendEmployee',
    method: 'post',
    data
  });
}


//  获取月度班级收支统计
export function getAllClassNowMonthStatistics(data) {
  return request({
    url: '/finance/GetAllClassNowMonthStatistics',
    method: 'post',
    data
  });
}

//  财务轧账月份列表
export function getFinanceMonthStatementPageList(data) {
  return request({
    url: '/finance/GetFinanceMonthStatementPageList',
    method: 'post',
    data
  });
}
//  财务轧账月份n 新增修改
export function setFinanceMonthStatementInfo(data) {
  return request({
    url: '/finance/SetFinanceMonthStatementInfo',
    method: 'post',
    data
  });
}




