import request from '../../utils/request'

/**
 * 获取OKR周期配置信息
 * @param {JSON参数} data 
 */
export function GetOKRPeriodConfigInfo(data) {
  return request({
    url: '/OKRPeriod/GetOKRPeriodConfigInfo',
    method: 'post',
    data
  })
}

/**
 * 保存OKR周期配置
 * @param {JSON参数} data 
 */
export function SetOKRPeriodConfigInfo(data) {
    return request({
      url: '/OKRPeriod/SetOKRPeriodConfigInfo',
      method: 'post',
      data
    })
}

/**
 * 获取规则分页列表
 * @param {JSON参数} data 
 */
export function GetOKRRulePageList(data) {
    return request({
      url: '/OKRPeriod/GetOKRRulePageList',
      method: 'post',
      data
    })
}

/**
 * 启用禁用删除规则状态
 * @param {JSON参数} data 
 */
export function SetOKRRuleState(data) {
    return request({
      url: '/OKRPeriod/SetOKRRuleState',
      method: 'post',
      data
    })
}

/**
 * 设置规则信息
 * @param {JSON参数} data 
 */
export function SetOKRRuleInfo(data) {
    return request({
      url: '/OKRPeriod/SetOKRRuleInfo',
      method: 'post',
      data
    })
}

/**
 * 获取规则枚举
 * @param {JSON参数} data 
 */
export function GetRuleTypeEnumList(data) {
    return request({
      url: '/OKRPeriod/GetRuleTypeEnumList',
      method: 'post',
      data
    })
}

/**
 * 获取OKR提醒列表
 * @param {JSON参数} data 
 */
export function GetOKRRemindList(data) {
    return request({
      url: '/OKRPeriod/GetOKRRemindList',
      method: 'post',
      data
    })
}

/**
 * 修改okr提醒启用
 * @param {JSON参数} data 
 */
export function SetOKRRemindEnable(data) {
  return request({
    url: '/OKRPeriod/SetOKRRemindEnable',
    method: 'post',
    data
  })
}

/**
 * 设置okr提醒
 * @param {JSON参数} data 
 */
export function SetOKRRemindInfo(data) {
  return request({
    url: '/OKRPeriod/SetOKRRemindInfo',
    method: 'post',
    data
  })
}

/**
 * 获取okr分数规则列表
 * @param {JSON参数} data 
 */
export function GetOKRScoreConfigPageList(data) {
  return request({
    url: '/OKRPeriod/GetOKRScoreConfigPageList',
    method: 'post',
    data
  })
}

/**
 * 设置分数规则
 * @param {JSON参数} data 
 */
export function SetOKRScoreConfigInfo(data) {
  return request({
    url: '/OKRPeriod/SetOKRScoreConfigInfo',
    method: 'post',
    data
  })
}

/**
 * 设置分数规则状态
 * @param {JSON参数} data 
 */
export function SetOKRScoreConfigState(data) {
  return request({
    url: '/OKRPeriod/SetOKRScoreConfigState',
    method: 'post',
    data
  })
}






  
