import request from '../../utils/request'

/**
 * 获取供应商分页列表
 */
export function querySupplierPage(data) {
    return request({
        url: '/StudyAbroad/GetSupplierPage',
        method: 'post',
        data
    })
}

/**
 * 获取供应商列表
 */
export function querySupplierList(data) {
    return request({
        url: '/StudyAbroad/GetSupplierList',
        method: 'post',
        data
    })
}


/**
 * 保存供应商信息
 */
export function saveSupplier(data) {
    return request({
        url: '/StudyAbroad/SetSupplier',
        method: 'post',
        data
    })
}


/**
 * 根据编号获取供应商信息
 */
export function querySupplierInfo(data) {
    return request({
        url: '/StudyAbroad/GetSupplier',
        method: 'post',
        data
    })
}

/**
 * 删除供应商
 */
export function deleteSupplier(data) {
    return request({
        url: '/StudyAbroad/RemoveSupplier',
        method: 'post',
        data
    })
}


/**
 * 获取留学就业分页列表
 */
export function queryStudyAbroadPage(data) {
    return request({
        url: '/StudyAbroad/GetStudyAbroadPage',
        method: 'post',
        data
    })
}


/**
 * 获取留学就业审核分页列表
 */
export function queryStudyAbroadAuditPage(data) {
    return request({
        url: '/StudyAbroad/GetStudyAbroadAuditPage',
        method: 'post',
        data
    })
}


/**
 * 获取留学就业列表
 */
export function queryStudyAbroadList(data) {
    return request({
        url: '/StudyAbroad/GetStudyAbroadList',
        method: 'post',
        data
    })
}


/**
 * 新增修改留学就业产品
 */
export function saveStudyAbroad(data) {
    return request({
        url: '/StudyAbroad/SetStudyAbroad',
        method: 'post',
        data
    })
}


/**
 * 根据编号获取留学就业产品信息
 */
export function queryStudyAbroadInfo(data) {
    return request({
        url: '/StudyAbroad/GetStudyAbroad',
        method: 'post',
        data
    })
}

/**
 * 更新留学就业产品状态
 */
export function deleteStudyAbroad(data) {
    return request({
        url: '/StudyAbroad/RemoveStudyAbroad',
        method: 'post',
        data
    })
}


/**
 * 批量更新留学就业优惠信息
 */
export function saveBatchStudyAbroad(data) {
    return request({
        url: '/StudyAbroad/BatchStudyAbroad',
        method: 'post',
        data
    })
}


/**
 * 留学就业提交审核
 */
export function saveSaleState(data) {
    return request({
        url: '/StudyAbroad/SetSaleState',
        method: 'post',
        data
    })
}

/**
 * 部门主管审核
 */
export function saveDirectorAudit(data) {
    return request({
        url: '/StudyAbroad/SetDirectorAudit',
        method: 'post',
        data
    })
}


/**
 * 部门负责人审核
 */
export function saveManagerAudit(data) {
    return request({
        url: '/StudyAbroad/SetManagerAudit',
        method: 'post',
        data
    })
}

/**
 * 获取留学就业审核人配置
 */
export function queryStudyAbroadAudit() {
    return request({
        url: '/StudyAbroad/GetStudyAbroadAudit',
        method: 'post'
    })
}


/**
 * 获取留学就业销售状态列表
 */
export function querySaleStateList() {
    return request({
        url: '/StudyAbroad/GetSaleStateList',
        method: 'post',
    })
}

/**
 * 获取供应商类别
 */
export function querySupplierType() {
    return request({
        url: '/StudyAbroad/GetSupplierType',
        method: 'post',
    })
}