import request from '../../utils/request'

/**
 * 重置用户密码信息
 */
export function resetPassword(data) {
    //参数信息AccountType AccountId
    return request({
        url: '/user/ResetUserPassword',
        method: 'post',
        data
    })
}

/**
 * 获取员工列表
 * @param {查询参数} data
 */
export function queryEmployee(data)
{
    return request({
        url: '/user/GetEmployeeList',
        method: 'post',
        data
    })
}

/**
 * 修改离职信息
 * @param {查询参数} data
 */
export function UpdateEmployeeLeave(data)
{
    return request({
        url: '/User/UpdateEmployeeLeaveTime',
        method: 'post',
        data
    })
}

/**
 * 修改部门
 * @param {查询参数} data
 */
export function UpdateEmployeeDept(data)
{
    return request({
        url: '/User/UpdateEmployeeDept',
        method: 'post',
        data
    })
}

/**
 * 修改岗位
 * @param {查询参数} data
 */
export function UpdateEmployeePost(data)
{
    return request({
        url: '/User/UpdateEmployeePost',
        method: 'post',
        data
    })
}

/**
 * 重置密码
 * @param {查询参数} data
 */
export function BatchResetUserPassword(data)
{
    return request({
        url: '/User/BatchResetUserPassword',
        method: 'post',
        data
    })
}
/**
 * 获取部门Id
 */
export function getEmployeeAddrBook(data)
{
  return request({
    url: '/User/GetEmployeeAddrBook',
    method: 'post',
    data
  })
}

/**
 * 个人资料修改
 */
 export function setEmployeeBaseInfo(data)
 {
   return request({
     url: '/UserInfo/SetEmployeeBaseInfo',
     method: 'post',
     data
   })
 }

 /**
 * 个人资料-修改密码
 */
  export function updateUserPassword(data)
  {
    return request({
      url: '/UserInfo/UpdateUserPassword',
      method: 'post',
      data
    })
  }

   /**
 * 获取个人中心信息
 */
    export function getUserCenterInfo(data)
    {
      return request({
        url: '/UserInfo/GetUserCenterInfo',
        method: 'post',
        data
      })
    }
  

      /**
 * 获取我的提成折线图
 */
    export function getUserSellCommission(data)
    {
      return request({
        url: '/UserInfo/GetUserSellCommission',
        method: 'post',
        data
      })
    }
      /**
 * 获取我的奖金折线图
 */
  export function getTeacherSellCommission(data)
  {
    return request({
      url: '/UserInfo/GetTeacherSellCommission',
      method: 'post',
      data
    })
  }
      /**
 * 个人中心 我的奖金确认  
 */
  export function updateSureTeachingBonusDetail(data)
  {
    return request({
      url: '/UserInfo/UpdateSureTeachingBonusDetail',
      method: 'post',
      data
    })
  }

      /**
 * 个人中心 我的提成确认  
 */
  export function updatSureSellCommission(data)
  {
    return request({
      url: '/UserInfo/UpdatSureSellCommission',
      method: 'post',
      data
    })
  }