import request from '../../utils/request'

/**
 * 获取学校分页列表
 * 
 */
export function getSchoolPage(data) {
  return request({
    url: '/user/GetSchoolPageList',
    method: 'post',
    data
  })
}

/**
 * 获取学校列表
 * 
 */
export function getSchoolDropdown(data) {
  return request({
    url: '/user/GetSchoolList',
    method: 'post',
    data
  })
}

/**
 * 获取学校分页列表
 */
export function saveSchool(data) {
  return request({
    url: '/user/SetSchool',
    method: 'post',
    data
  })
}

/**
 * 根据校区编号获取校区信息
 */
export function getSchoolInfo(data) {
  return request({
    url: '/user/GetSchool',
    method: 'post',
    data
  })
}

/**
 * 获取教师分页数据 
 */
export function getTeacherPage(data) {
  return request({
    url: '/user/GetTeacherPageList',
    method: 'post',
    data
  })
}

/**
 * 获取讲师列表
 */
export function getTeacherDropDownList(data) {
  return request({
    url: '/user/GetTeacherList',
    method: 'post',
    data
  })
}

/**
 * 保存教师信息
 */
export function saveTeacher(data) {
  return request({
    url: '/user/SetTeacher',
    method: 'post',
    data
  })
}
/**
 * 教师审核
 */
export function auditTeacher(data) {
  return request({
    url: '/user/AuditTeacher',
    method: 'post',
    data
  })
}

/**
 * 
 * @param {TId} data 
 */
export function deleteTeacher(data) {
  return request({
    url: '/user/RemoveTeacher',
    method: 'post',
    data
  })
}

/**
 * 重新审核审核
 * @param {TId} data 
 */
export function reApplyTeacher(data) {
  return request({
    url: '/user/ReApplyTeacher',
    method: 'post',
    data
  })
}

/**
 * 获取助教分页数据 
 */
export function getAssistPage(data) {
  return request({
    url: '/user/GetAssistPageList',
    method: 'post',
    data
  })
}

/**
 * 获取助教下拉列表
 * @param {JSON对象} data 
 */
export function getAssistDropDownList(data) {
  return request({
    url: '/user/GetAssistList',
    method: 'post',
    data
  })
}

/**
 * 保存教师信息
 */
export function saveAssist(data) {
  return request({
    url: '/user/SetAssist',
    method: 'post',
    data
  })
}

/**
 * 教师审核
 */
export function auditAssist(data) {
  return request({
    url: '/user/AuditAssist',
    method: 'post',
    data
  })
}

/**
 * 助教删除
 * @param {AId} data 
 */
export function deleteAssist(data) {
  return request({
    url: '/user/RemoveAssist',
    method: 'post',
    data
  })
}

/**
 * 助教重新申请审核
 * @param {AId} data 
 */
export function reApplyAssist(data) {
  return request({
    url: '/user/ReApplyAssist',
    method: 'post',
    data
  })
}

/**
 * 获取班级分页列表
 * @param {JSON数据} data 
 */
export function getClassPage(data) {
  return request({
    url: '/Class/GetClassPageList',
    method: 'post',
    data
  })
}

/**
 * 获取班级列表【下拉使用】
 * @param {JSON数据} data 
 */
export function getClassDropDownList(data) {
  return request({
    url: '/Class/GetClassList',
    method: 'post',
    data
  })
}

/**
 * 新增修改班级
 * @param {JSON数据} data 
 */
export function saveClass(data) {
  return request({
    url: '/Class/SetClass',
    method: 'post',
    data
  })
}

/**
 * 新增修改班级
 * @param {JSON数据} data 
 */
export function getClassInfo(data) {
  return request({
    url: '/Class/GetClass',
    method: 'post',
    data
  })
}

/**
 * 删除班级
 * @param {JSON数据} data 
 */
export function deleteClass(data) {
  return request({
    url: '/Class/RemoveClass',
    method: 'post',
    data
  })
}

/**
 * 获取学员分页列表
 * @param {JSON数据} data 
 */
export function getStudentPage(data) {
  return request({
    url: '/User/GetStudentPageList',
    method: 'post',
    data
  })
}

/**
 * 获取学员下拉类表
 */
export function getStudentDorpDownList(data) {
  return request({
    url: '/User/GetStudentList',
    method: 'post',
    data
  })
}


/**
 * 添加修改学员
 */
export function saveStudent(data) {
  return request({
    url: '/User/SetStudent',
    method: 'post',
    data
  })
}


/**
 * 获取学员信息
 */
export function getStudentInfo(data) {
  return request({
    url: '/User/GetStudent',
    method: 'post',
    data
  })
}

/**
 * 删除学员信息
 */
export function deleteStudent(data) {
  return request({
    url: '/User/RemoveStudent',
    method: 'post',
    data
  })
}

/**
 * 更新学生禁用或启用
 */
export function UpdateStudentIsDisable(data) {
  return request({
    url: '/User/UpdateStudentIsDisable',
    method: 'post',
    data
  })
}

/**
 * 创建学生账号
 */
export function createStudentAccount(data) {
  return request({
    url: '/User/CreateStudentAccount',
    method: 'post',
    data
  })
}

/**
 * 获取管理者分页列表
 */
export function queryManagerPage(data) {
  return request({
    url: '/User/GetManagerPageList',
    method: 'post',
    data
  })
}

/**
 * 新增修改管理者
 */
export function saveManager(data) {
  return request({
    url: '/User/SetEmployee',
    method: 'post',
    data
  })
}

/**
 * 获取管理者信息
 */
export function queryEmployeeInfo(data) {
  return request({
    url: '/User/GetEmployee',
    method: 'post',
    data
  })
}


/**
 * 获取管理者信息
 */
export function deleteManagerInfo(data) {
  return request({
    url: '/User/RemoveManager',
    method: 'post',
    data
  })
}

/**
 * 创建管理者账号
 */
export function createManagerAccount(data) {
  return request({
    url: '/User/CreateManagerAccount',
    method: 'post',
    data
  })
}

/**
 * 获取学历列表
 * 
 */
export function getEducation(data) {
  return request({
    url: '/User/GetEducationList',
    method: 'post',
    data
  });
}

/**
 * 获取在职状态
 * 
 */
export function GetLeaveStatus(data) {
  return request({
    url: '/User/GetLeaveStatus',
    method: 'post',
    data
  });
}

/**
 * 获取教室分页列表
 * 
 */
export function queryClassRoomPage(data) {
  return request({
    url: '/ClassRoom/GetClassRoomPageList',
    method: 'post',
    data
  });
}

/**
 * 获取教室列表
 */
export function queryClassRoomList(data) {
  return request({
    url: '/ClassRoom/GetClassRoomList',
    method: 'post',
    data
  });
}

/**
 * 新增修改教室
 */
export function saveClassRoom(data) {
  return request({
    url: '/ClassRoom/SetClassRoom',
    method: 'post',
    data
  });
}

/**
 * 根据教室编号获取教室详情
 */
export function quertClassRoomInfo(data) {
  return request({
    url: '/ClassRoom/GetClassRoom',
    method: 'post',
    data
  });
}

/**
 * 根据教室编号删除教室
 */
export function deleteClassRoomInfo(data) {
  return request({
    url: '/ClassRoom/RemoveClassRoom',
    method: 'post',
    data
  });
}
