import request from '../../utils/request'

/**
 * 获取课程分页列表
 * @param {JSON参数} data
 */
export function queryClassPage(data) {
  return request({
    url: '/Class/GetClassPageList',
    method: 'post',
    data
  })
}


/**
 * 获取课程状态列表
 * @param {JSON参数} data
 */
export function queryClassStatusList() {
  return request({
    url: '/Class/GetClassStatusList',
    method: 'post',
    data: ""
  })
}

/**
 * 获取班级学员列表
 */
export function queryClassStudent(data) {
  return request({
    url: '/Class/GetClassStudent',
    method: 'post',
    data
  });
}

/**
 * 获取上课计划列表
 */
export function quertClassPlan(data) {
  return request({
    url: '/Class/GetClassPlan',
    method: 'post',
    data
  });
}

/**
 * 新增修改课程安排
 */
export function setClassPlan(data) {
  return request({
    url: '/Class/SetClassPlan',
    method: 'post',
    data
  });
}

/**
 * 删除课程安排
 */
export function RemoveClassPlan(data) {
  return request({
    url: '/Class/RemoveClassPlan',
    method: 'post',
    data
  });
}

/**
 * 学员退课
 */
export function StudentDropOut(data) {
  return request({
    url: '/Class/UpdateClassStudentDropOut',
    method: 'post',
    data
  });
}

/**
 * 获取学员下拉数据
 */
export function GetStudentList(data) {
  return request({
    url: '/class/GetStudentList',
    method: 'post',
    data
  });
}

/**
 * 邀请学员
 */
export function AddClassStudent(data) {
  return request({
    url: '/class/AddClassStudent',
    method: 'post',
    data
  });
}

/**
 * 获取签到列表数据
 */
export function GetClassPlanLogPageList(data) {
  return request({
    url: '/class/GetClassPlanLogPageList',
    method: 'post',
    data
  });
}

/**
 * 获取某一天计划
 */
export function GetDayClassPlan(data) {
  return request({
    url: '/class/GetDayClassPlan',
    method: 'post',
    data
  });
}

/**
 * 点击签到
 */
export function addClassCheck(data) {
  return request({
    url: '/class/AddClassCheck',
    method: 'post',
    data
  });
}

/**
 * 获取班级日志
 */
export function queryClassLogPageList(data) {
  return request({
    url: '/class/GetClassLogPageList',
    method: 'post',
    data
  });
}

/**
 * 获取备课信息列表
 */
export function GetTeacherPlan(data) {
  return request({
    url: "/Class/GetTeacherPlan",
    method: 'post',
    data
  })
}
/**
 * 获取教案
 */
export function getClassLessPlan(data) {
  return request({
    url: "/Class/GetClassLessPlan",
    method: 'post',
    data
  })
}
/**
 * 获取教案 评论列表
 */
export function getLessonCommentList(data) {
  return request({
    url: "/Class/GetLessonCommentList",
    method: 'post',
    data
  })
}
/**
 * 获取教案 评论列表
 */
export function setLessonComment(data) {
  return request({
    url: "/Class/SetLessonComment",
    method: 'post',
    data
  })
}
/**
 * 获取教案详情的 提交
 */
export function updateClassLessPlan(data) {
  return request({
    url: "/Class/UpdateClassLessPlan",
    method: 'post',
    data
  })
}
/**
 * 教师课时奖励 分页列表
 */
export function getTeachingBonusPageList(data) {
  return request({
    url: '/TeachingRewards/GetTeachingBonusPageList',
    method: 'post',
    data
  });
}

/**
 * 教师奖励状态 枚举
 */
export function getBonusStateEnumList(data) {
  return request({
    url: '/TeachingRewards/GetBonusStateEnumList',
    method: 'post',
    data
  });
}

/**
 * 新增课时奖励
 */
export function setTeachingBonusAdd(data) {
  return request({
    url: '/TeachingRewards/SetTeachingBonusAdd',
    method: 'post',
    data
  });
}
/**
 * 设置教师奖励状态
 */
export function setTeachingBonusState(data) {
  return request({
    url: '/TeachingRewards/SetTeachingBonusState',
    method: 'post',
    data
  });
}
/**
 * 教师奖励 生成财务单据
 */
export function setTeachingBonusFinance(data) {
  return request({
    url: '/TeachingRewards/SetTeachingBonusFinance',
    method: 'post',
    data
  });
}
/**
 * 获取教师课时奖励明细
 */
export function getTeachingBonusDetailList(data) {
  return request({
    url: '/TeachingRewards/GetTeachingBonusDetailList',
    method: 'post',
    data
  });
}
/**
 * 教师绩效分页列表
 */
export function getTeachingPerfPageList(data) {
  return request({
    url: '/TeachingRewards/GetTeachingPerfPageList',
    method: 'post',
    data
  });
}
/**
 * 教师绩效 设置备注
 */
export function setTeachingPerfRemark(data) {
  return request({
    url: '/TeachingRewards/SetTeachingPerfRemark',
    method: 'post',
    data
  });
}
/**
 * 教师绩效 设置状态
 */
export function setTeachingPerfState(data) {
  return request({
    url: '/TeachingRewards/SetTeachingPerfState',
    method: 'post',
    data
  });
}
/**
 * 教师绩效 设置状态
 */
export function setTeachingPerfFinance(data) {
  return request({
    url: '/TeachingRewards/SetTeachingPerfFinance',
    method: 'post',
    data
  });
}

/**
 * 修改班级状态
 * @param {JSON数据} data
 */
export function saveClassStatus(data) {
    return request({
      url: '/Class/SetClassStatus',
      method: 'post',
      data
    })
}


/**
 * 获取老师教案
 */
export function GetClassLessPlan(data) {
    return request({
      url: '/Class/GetClassLessPlan',
      method: 'post',
      data
    });
}

/**
 * 新增老师教案
 */
export function SetClassLessPlan(data) {
    return request({
      url: '/Class/SetClassLessPlan',
      method: 'post',
      data
    });
}

/**
 * 获取备课模板
 */
export function GetClassLessPlanList(data) {
    return request({
      url: '/Class/GetClassLessPlanList',
      method: 'post',
      data
    });
}
