import Vue from 'vue'
import App from './App.vue'
import router from './router'
import store from './store'
import './registerServiceWorker'
import './plugins/element.js'
import ElementUI from 'element-ui'
import plug from './plugins/index'
import 'element-ui/lib/theme-chalk/index.css'
import axios from 'axios'
import echarts from 'echarts'
import VueSocketio from 'vue-socket.io';
import socketio from 'socket.io-client';
// Vue.use(VueSocketio,socketio('http://127.0.0.1:5000/data_server'));
// 使用Vue.use()方法就会调用工具方法中的install方法
// Vue.use(VueLazyload, {
//   preLoad: 1.3,
//   error: '../src/assets/img/banner@3x.png',
//   loading: '../src/assets/img/loader.gif',
//   attempt: 1
// })

Vue.config.productionTip = false
Vue.use(ElementUI)
Vue.use(plug)
Vue.http = Vue.prototype.$http = axios
Vue.prototype.$echarts = echarts
Vue.prototype.$VueSocketio = VueSocketio
Vue.prototype.$socketio = socketio
router.beforeEach((to, from, next) => {  
  if (to.meta.title) {    
    document.title = to.meta.title  
  }  
  next()
})
Vue.prototype.getLocalStorage = function() {
  var localStorageData = window.localStorage["userInfo"];
  if (localStorageData != undefined) {
      return JSON.parse(localStorageData);
  } else {
      return null;
  }
},
new Vue({
  router,
  store,
  render: h => h(App)
}).$mount('#app')
