﻿import md5 from 'js-md5'
import bus from "./bus";

export default {
    data: {
        loginUser: {},
        apiurl: ''
    },
    install(Vue, options) {
        Vue.prototype.isOnline = function() {
            return process.env.NODE_ENV !== 'development';
        },
        //域名管理对象
        Vue.prototype.domainManager = function() {
            // var domainUrl = "http://test_reborn.oytour.com";//主域名
            //var domainUrl = "http://reborn.oytour.com"; //主域名
            var domainUrl = "http://reborn.oytour.com";//主域名

            if (this.isOnline()) {
                domainUrl = "http://reborn.oytour.com";
            }
            var obj = {
                //主地址
                DomainUrl: domainUrl,
                //常用提交数据URL 
                PostUrl: domainUrl + "/api/common/post"
            };
            return obj;
        },
        //消息成功提示
        Vue.prototype.Success = function(msg) {
            this.$message({
                message: msg,
                duration: 2000,
                type: "success"
            });
        },
        //错误提示
        Vue.prototype.Error = function(msg) {
            this.$message({
                message: msg,
                duration: 2000,
                type: "error"
            });
        },

        //一般提示
        Vue.prototype.Info = function(msg) {
            this.$message({
                message: msg,
                duration: 2000,
                type: "info"
            });
        },
        //警告提示
        Vue.prototype.Warning = function(msg) {
            this.$message({
                message: msg,
                duration: 2000,
                type: "warning"
            });
        },
        //Confirm
        Vue.prototype.Confirm = function(msg, callback) {
            this.$confirm(msg, "提示", {
                    confirmButtonText: "确定",
                    cancelButtonText: "取消",
                    type: "warning"
                })
                .then(() => {
                    if (typeof callback === 'function') {
                        callback();
                    }
                })
                .catch(() => {
                    this.Info("已取消操作");
                });
        },
        //打开新窗口连接
        Vue.prototype.OpenNewUrl = function(URL) {
            if (URL != '') {
                window.open('http://' + URL, '_blank');
            }
        }
        Vue.prototype.apipost = function(cmd, msg, successCall, faildCall) {
            if (msg == null || msg == "") {
                msg = {}
            }
            var apiurl = this.domainManager().PostUrl;
            var timestamp = (new Date()).valueOf();
            this.apiurl = apiurl;
            var token = "";
            var key = "";
            if (localStorage.user && localStorage.user!='') {
                token = JSON.parse(localStorage.user).token;
                key = JSON.parse(localStorage.user).SecretKey;
            }
            var encodeMsg = encodeURIComponent(JSON.stringify(msg)).toLowerCase();
            var md5Str = md5(`cmd=${cmd}&msg=${encodeMsg}&timestamp=${timestamp}&token=${token}&key=${key}`);
            var postData = {
                "msg": msg,
                "cmd": cmd,
                "timestamp": timestamp,
                "token": token,
                "sign": md5Str
            }
            this.$http.post(apiurl, postData, {
                    headers: {
                        'Content-Type': 'application/json',
                        'Referer-Viitto': this.$route.path
                    }
                })
                .then(res => {
                    if (res.resultCode == 10000 || res.resultCode == 10001) {
                        this.$router.push({
                            path: '/login'
                        })
                    } else if (res.resultCode == 10005) {
                        this.$router.go(-1)
                    } else {
                        successCall(res)
                    }
                }, faildCall)
        }
        Vue.prototype.apiRequest = function(path, msg, successCall, faildCall) {
            if (msg == null || msg == "") {
                msg = {}
            }
            
            this.$http.post(path, msg, {
                    headers: {
                        'Content-Type': 'application/json'
                    }
                })
                .then(res => {
                        successCall(res)
                }, faildCall)
        }
        Vue.prototype.bus=bus
        Vue.prototype.alert = function(title,content){
            title=!title&&title==''?'系统提示':title
            console.log(title)
            let obj={
                title,
                content
            }
            bus.$emit('create','alert',obj)
        }

        //验证只能输入2位小数
        Vue.prototype.checkPrice = function(item, filed) {
            var value = "";
            if (typeof item[filed] == "string") {
                value = item[filed];
            } else {
                value = item[filed].toString();
            }
            value = value.replace(/[^\d.]/g, ""); //清除“数字”和“.”以外的字符
            value = value.replace(/\.{2,}/g, "."); //只保留第一个. 清除多余的
            value = value
                .replace(".", "$#$")
                .replace(/\./g, "")
                .replace("$#$", ".");
            value = value.replace(/^(\-)*(\d+)\.(\d\d).*$/, "$1$2.$3"); //只能输入两个小数
            if (value.indexOf(".") < 0 && value != "") {
                //以上已经过滤，此处控制的是如果没有小数点，首位不能为类似于 01、02的金额
                value = parseFloat(value);
            }
            item[filed] = value;
        }
        //验证只能输入整数
        Vue.prototype.checkInteger = function(item, filed) {
            var value = "";
            if (typeof item[filed] == "string") {
                value = item[filed];
            } else {
                value = item[filed].toString();
            }
            value = value.replace(this.$commonUtils.Regex.isInteger, "");
            item[filed] = value;
        }

    }
}