import { StaticConfig } from '@/config/app'
import { useMeta } from 'quasar'
import { ref } from 'vue'

const userMetaTitleModule = () => {
  const title = ref(StaticConfig.appsuffix)
  useMeta(() => {
    return {
      title: title.value
    }
  })

  const setTitle = (pageTitle: string, suffix = true) => {
    if (suffix) {
      title.value = `${pageTitle}-${StaticConfig.appsuffix}`
    } else {
      title.value = pageTitle
    }
  }

  return { setTitle }
}

export default userMetaTitleModule
