import { ResultType } from '@/@types/enumHelper'
import router from '@/router'
import { UserActionsType } from '@/store/modules/user/actions'
import { UserGetter } from '@/store/modules/user/getters'
import { dispatchAction, getStoreGetter, setStoreState } from '@/store/utils'
import message from '@/utils/message'
import { reactive, ref } from 'vue'
interface LoginParams {
  username: string
  password: string
  remeber: boolean
}

const userUserLoginModule = () => {
  const userModel: LoginParams = reactive({
    username: '',
    password: '',
    remeber: false
  })

  const userValidateRule = reactive({
    usernameRule: [(val: any) => !!val || '请填写账户信息'],
    userpasswordRule: [(val: any) => !!val || '请填写密码信息']
  })
  const stateManager = reactive({
    subLogin: ref(false)
  })
  const usernameRef = ref(null)
  const passwordRef = ref(null)

  const loginSubmit = () => {
    if (!stateManager.subLogin) {
      stateManager.subLogin = true
      const ur = usernameRef as any //断言任意类型
      const pr = passwordRef as any
      ur.value.validate()
      pr.value.validate()
      if (ur.value.hasError || pr.value.hasError) {
        message.warnMsg('请完善登录信息')
        stateManager.subLogin = false
      } else {
        
        setTimeout(() => {
          //#region 测试使用
          const param = {
            username: userModel.username,
            password: userModel.password
          }

          dispatchAction<UserActionsType>('user', 'userLogin', param)

          const menu:any = {
            menuId: 1,
            menuName: '首页',
            menuUrl: '/index'
          }
          const menu2:any = {
            menuId: 2,
            menuName: '首页',
            menuUrl: '/'
          }
          const menus: Array<any> = []
          const auths = getStoreGetter<UserGetter>('user', 'getUserAllAuth')
          if (auths != ResultType.EmptyArray) {
            Object.assign(menus, ...auths)
          }
          menus.push(menu)
          menus.push(menu2)
          setStoreState('user', 'menuList', menus)
          message.successMsg('登录成功')
          stateManager.subLogin = false
          router.push({
            path: '/index'
          })
          //#endregion
        }, 2000)
      }
    }
  }

  return { userModel, usernameRef, passwordRef, userValidateRule, loginSubmit, stateManager }
}

export default userUserLoginModule
