import { Notify, QSpinnerIos } from 'quasar'

const message = {
  warnMsg: (msg: string) => {
    Notify.create({
      message: msg,
      color: 'warning',
      textColor: 'dark',
      position: 'top',
      icon: 'announcement'
    })
  },
  errorMsg: (msg: string) => {
    Notify.create({
      message: msg,
      type: 'negative',
      position: 'top'
    })
  },
  successMsg: (msg: string) => {
    Notify.create({
      message: msg,
      color: 'positive',
      position: 'top',
      textColor: 'white',
      icon: 'check'
    })
  },
  loadMsg: (msg: string): any => {
    const loadDissmiss = Notify.create({
      message: msg,
      color: 'secondary',
      position: 'center',
      textColor: 'dark',
      spinner: QSpinnerIos
    })
    return loadDissmiss
  }
}

export default message
