<a name="lgzKP"></a>
## 项目框架：
项目采用Quasar+Vue3.2+TS，构建。开发中需要严格遵守TS协议，语法，对象等标准。严厉杜绝直接使用JS的弱类型。严格遵守composition api，杜绝Option api。项目后期会加入Vite2作为打包工具，放弃Webpack。
> 项目弃用了ESLint语法约束，开发人员需要按照Prettier 格式化代码，并且处理语法不合规的内容，严禁关闭ESLint语法验证。

​<br />
<a name="WJ7J1"></a>
## 第三方依赖：
> cnpm i -S @types/webpack-env         自动注入
> cnpm i -S vuex-persistedstate             持久化Store
> cnpm install --save @types/lockr     LocalStorage管理工具
> cnpm install --save @types/lodash      JS 原生库，封装了许多实用方法，项目使用初衷为全局组件注册的一致性

注意Store已加入自动化注入功能，请按照示例格式进行添加<br />store的持久化需要在index.ts文件中进行配置
```typescript
process.env.NODE_ENV !== 'production'
      ? [
          createLogger(),
          createPersistedState({
            paths: ['app', 'user','你的Store名称']
          })
        ]
      : [
          createPersistedState({
            paths: ['app', 'user','你的Store名称']
          })
        ]
```
<a name="GdhGb"></a>
## 项目基础架构说明：
```
|-- 根目录
    |-- quasar-cli文件，不需要做调整		
    |-- dist 项目 build 之后的文件夹
    |-- public 项目静态资源，不经过 webpack，以及默认的模版，适合存放第三方压缩好的资源
    |-- src 主要的开发目录
    | |-- @types 项目共用的 type
    | |-- App.vue 页面渲染根节点
    | |-- main.ts 入口文件
    | |-- shims-vue.d.ts vue 文件类型的 type
    | |-- api 封装http请求相关（持久层）
    | | |-- apiList.ts api接口列表（弃用，在各自的Service中维护）
    | | |-- axios.ts 业务请求封装 （封装Request AOP）
    | | |-- Common.ts 公共模块的的网络请求，所有通用 api 放在此处（例如请求枚举之类）
    | | |-- user.ts 用户请求模块（示例）
    | |-- assets 存放静态资源，这个文件夹下的文件会走 webpack 压缩流程
    | |-- boot quasar全局组件封装目录
    | | |-- axios.ts 弃用
    | | |-- dict.ts 字典库（用于魔法值的封装，注意项目全局不能存在魔法值）
    | | |-- i18n.ts 国际化
    | | |-- permission.ts 路由权限封装
    | |-- components
    | | |-- index.ts 自动注册脚本
    | | |-- global 自动注册的全局组件
    | | |-- ...其他非全局注册的模块（按照实际需要创建目录管理组件，严禁直接在cmp根目录创建）
    | |-- config 全局静态配置，不可更改项
    | | |-- app.ts 全局配置信息
    | | |-- color.ts 示例
    | | |-- dictionary.ts 魔法值定义类，按照项目需要自行创建部分类
    | |-- css 样式存放目录（注意遵从Sass或Scss创建，不允许使用原生CSS）
    | |-- i18n 国际化配置
    | |-- layout 页面页面骨架
    | |-- module 遵从Vue3.x cmpApi对Setup进行拆分封装，按照领域划分文件夹，类名+Module
		| | |-- user
		| | | |-- loginModule.ts 示例：内部应该遵从usexxxxModule规范命名
    | |-- pages 页面级组件
    | |-- router 路由
    | | |-- index.ts 路由入口
    | |-- store vuex
    | | |-- modules 多个模块
    | | |-- index.ts 自动装载模块
    | | |-- app app 模块
    | |-- utils 常用函数以及其他有用工具
    | | |-- auth.ts 身份验证中间件
    | | |-- message.ts 消息组件封装
    | | |-- tools.ts 工具类
    | | |-- validate.ts 验证封装
    |-- .czrc 提交规范选项设置
    |-- .editorconfig vscode 编辑器 设置
    |-- .env.development 开发环境配置
    |-- .env.preview 测试环境配置
    |-- .env.production 生产环境配置
    |-- .eslintignore eslint 要忽略的文件夹
    |-- .eslintrc.js eslint 规则配置
    |-- .gitignore git 忽略的文件
    |-- .prettierrc.js 格式化插件配置
    |-- README.md 项目说明
    |-- babel.config.js babel 设置
    |-- package.json npm 配置
    |-- tsconfig.json typescript 配置
    |-- typedoc.json 文档配置文件
    |-- quasar.conf.js quasar 脚手架配置文件

```

<br />
<br />​<br />
