import message from '@/utils/message'
import { reactive,ref } from 'vue'
interface LoginParams {
  username: string
  password: string
  remeber: boolean
}

const userUserLoginModule = () => {
  const userModel: LoginParams = reactive({
    username: '',
    password: '',
    remeber: false
  })

  const userValidateRule = reactive({
    usernameRule: [(val: any) => !!val || '请填写账户信息'],
    userpasswordRule: [(val: any) => !!val || '请填写密码信息']
  })

  const usernameRef=ref(null)
  const passwordRef=ref(null)

  const loginSubmit = () => {
    const ur=(usernameRef as any) //断言任意类型
    const pr=(passwordRef as any)
    ur.value.validate()
    pr.value.validate()
    if (ur.value.hasError || pr.value.hasError) {
      message.warnMsg('请完善登录信息')
    } else {
      message.successMsg('验证通过')
    }
  }

  return { userModel, usernameRef, passwordRef, userValidateRule, loginSubmit }
}

export default userUserLoginModule
