﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TicketSpider.Model;

namespace TicketSpider.Spiders
{
    public class CityService
    {
        public static List<City> CITIES = new List<City>();

        public static bool Load()
        {
            string cityJsonFile = Environment.CurrentDirectory + "\\zh_CN.json";
            if (File.Exists(cityJsonFile)) 
            {
                using (StreamReader file = File.OpenText(cityJsonFile))
                {
                    using (JsonTextReader reader = new JsonTextReader(file))
                    {
                        try
                        {
                            var o = (JArray)JToken.ReadFrom(reader);
                            CITIES = JsonConvert.DeserializeObject<List<City>>(JsonConvert.SerializeObject(o));
                            return true;
                        }
                        catch (Exception){ }

                    }
                }
            }

            return false;
        }

        public static City? GetCityHandler(string city)
        {
            return CITIES.Where(x => x.cityName == city).FirstOrDefault();
        }

        public static bool Container(string city)
        {
            return CITIES.Where(x => x.cityName == city).Count() > 0;
        }
    }
}
