﻿using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using System.Collections.Generic;
using VTX.FW.Config;
using VTX.FW.DB;

namespace EduSpider.IRepository
{
    /// <summary>
    /// 课程评价配置详情仓储接口
    /// </summary>
    public interface ICourseCommentDetailsRepository:IDBRepository<RB_Course_CommentDetails>, IDependency
    {
        /// <summary>
        /// 新增修改课程评价
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public bool SetCourseCommentDetailsRepository(List<RB_Course_CommentDetails_Extend> list);

        /// <summary>
        /// 获取课程评价配置列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_CommentDetails_Extend> GetCourseCommentDetailsListRepository(RB_Course_CommentDetails_Extend query);


        /// <summary>
        /// 根据编号删除课程评价详情配置
        /// </summary>
        /// <param name="DetailIds"></param>
        /// <returns></returns>
        public bool DeleteCourseCommentDetailsRepository(string DetailIds);
    }
}
