﻿using EduSpider.Model.Entity;
using EduSpider.Model.Query;
using EduSpider.Repository.Base;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VTX.FW.DB.Dapper;

namespace EduSpider.Repository
{
    /// <summary>
    /// 课程仓储层
    /// </summary>
    public class CourseRepository : BaseRepository<RB_Course>, ICourseRepository
    {
        /// <summary>
        /// 批量新增课程
        /// </summary>
        /// <param name="courses"></param>
        /// <returns></returns>
        public bool BatchSetCourseRepository(List<RB_Course> courses)
        {
            bool flag;
            flag = base.BatchInsert(courses, isReplace: true);
            return flag;
        }

        /// <summary>
        /// 批量修改其他字段
        /// </summary>
        /// <param name="courses"></param>
        /// <returns></returns>
        public bool BatchSetCourseOtherRepository(List<RB_Course> courses)
        {
            var parameters = new DynamicParameters();
            string sql = @" 
UPDATE RB_Course 
SET courseWare=@courseWare,coverImg=@coverImg,courseType=@courseType,addTime=@addTime
WHERE courseId=@courseId ";
            parameters.Add("courseWare", courses[0].CourseWare);
            parameters.Add("coverImg", courses[0].CoverImg);
            parameters.Add("courseType", courses[0].CourseType);
            parameters.Add("addTime", courses[0].AddTime);
            parameters.Add("courseId", courses[0].CourseId);
            return Execute(sql, parameters) > 0;
        }

        /// <summary>
        /// 获取课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course> GetCourseListRepository(CourseQuery query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*
FROM RB_Course AS A
WHERE 1=1
");
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.CourseName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @courseName ", nameof(RB_Course.CourseName));
                    parameters.Add("courseName", "%" + query.CourseName.Trim() + "%");
                }
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Course.CourseId), query.CourseId);
                }
            }
            return base.Get<RB_Course>(builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取课程分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course> GetCoursePageRepository(int pageIndex, int pageSize, out long rowsCount, CourseQuery query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*
FROM RB_Course AS A
WHERE 1=1
");
            if (query != null)
            {
                if (!string.IsNullOrWhiteSpace(query.CourseName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @courseName ", nameof(RB_Course.CourseName));
                    parameters.Add("courseName", "%" + query.CourseName.Trim() + "%");
                }
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Course.CourseId), query.CourseId);
                }
            }
            return base.GetPage<RB_Course>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }
    }
}
