﻿using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using EduSpider.Repository.Base;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VTX.FW.DB.Dapper;

namespace EduSpider.Repository
{
    /// <summary>
    /// 考试得分仓储层
    /// </summary>
    public class Exam_ScoreRepository : BaseRepository<RB_Exam_Score>, IExam_ScoreRepository
    {

        /// <summary>
        /// 学生考试查询
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Exam_Score_Extend> GetExamScoreListRepository(CourseQuery query)
        {
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*,B.ExamName,B.CreateTime AS ExamCreateTime
FROM RB_Exam_Score AS A INNER JOIN rb_exam AS B ON A.ExamId=B.ExamId
WHERE 1=1 and B.Status =0
");
            if (query != null)
            {
                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND B.{0}={1} ", nameof(RB_Exam.CourseId), query.CourseId);
                }
                if (!string.IsNullOrEmpty(query.StuIds))
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Exam_Score_Extend.StuUId), query.StuIds);
                }
            }
            return Get<RB_Exam_Score_Extend>(builder.ToString()).ToList();
        }

        public List<RB_Exam_Score_Extend> GetList(RB_Exam_Score_Extend dmodel)
        {
            var parameters = new DynamicParameters();
            string where = " 1=1";
            if (dmodel.ExamId > 0)
            {
                where += $" and {nameof(RB_Exam_Score_Extend.ExamId)} ={dmodel.ExamId}";
            }
            if (dmodel.StuId > 0)
            {
                where += $" and {nameof(RB_Exam_Score_Extend.StuId)} ={dmodel.StuId}";
            }
            if (dmodel.StuUId > 0)
            {
                where += $" and {nameof(RB_Exam_Score_Extend.StuUId)} ={dmodel.StuUId}";
            }
            if (!string.IsNullOrEmpty(dmodel.StuName))
            {
                where += $" and {nameof(RB_Exam_Score_Extend.StuName)} like @StuName";
                parameters.Add("StuName", "%" + dmodel.StuName.Trim() + "%");
            }
            string sql = $"select * from RB_Exam_Score where {where}";
            return Get<RB_Exam_Score_Extend>(sql, parameters).ToList();
        }
    }
}
