﻿using System;
using System.IO;
using System.Threading;
using VTX.FW.Helper;

namespace EduSpider.WebApi.Timers
{
    /// <summary>
    /// 定时任务
    /// </summary>
    public class TimerJobj
    {

        static System.Timers.Timer timer1;//计时器

        public static void RunTimer()
        {
            timer1 = new System.Timers.Timer
            {
                Interval = (1000 * 60) * (60 * 3) //3小时执行一次
            };
            timer1.Elapsed += new System.Timers.ElapsedEventHandler(ClearFile);
            timer1.Enabled = true;
        }

        public static void RunStop()
        {
            timer1.Enabled = false;
        }

        /// <summary>
        /// 防止重复提交
        /// </summary>
        private static int inTimer = 0;
        
        /// <summary>
        /// 清理文件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public static void ClearFile(object sender, System.Timers.ElapsedEventArgs e)
        {
            if (Interlocked.Exchange(ref inTimer, 1) == 0)
            {
                string rootBook = AppDomain.CurrentDomain.BaseDirectory;
                try
                {
                    DirectoryInfo dir = new(rootBook + "/upfile/temporary");
                    if (dir != null && dir.Exists)
                    {
                        DirectoryInfo[] dirArr = dir.GetDirectories();
                        foreach (DirectoryInfo item in dirArr)
                        {
                            if (item.CreationTime < DateTime.Now.AddDays(-1))
                                item.Delete(true);
                        }
                        foreach (FileInfo fi in dir.GetFiles())
                        {
                            if (fi.CreationTime < DateTime.Now.AddDays(-1))
                                fi.Delete();
                        }
                    }
                }
                catch
                {
                    LogHelper.WriteInfo("ClearFile", "清理临时文件失败_ClearFile");
                }
                Interlocked.Exchange(ref inTimer, 0);
            }
        }

    }
}