﻿
using EduSpider.IServices;
using EduSpider.Model.Extend;
using EduSpider.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.Attr;
using VTX.FW.DB;

namespace EduSpider.Services
{
    /// <summary>
    /// 账号服务实现
    /// </summary>
    public class AccountService : IAccountService
    {

        /// <summary>
        /// 帐号仓储接口
        /// </summary>
        [Autowired]
        public IAccountRepository accountRepository { get; set; }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<rb_account_hk_Extend> GetAccountList(rb_account_hk_Extend demodel)
        {
            return accountRepository.GetAccountList(demodel);
        }

        /// <summary>
        /// 更新微信信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool UpdateAccountUnionId(rb_account_hk_Extend model)
        {
            Dictionary<string, object> keyValues = new() {
                { nameof(rb_account_hk_Extend.OpenId), model.OpenId},
                { nameof(rb_account_hk_Extend.UnionId), model.UnionId},
            };
            List<WhereHelper> wheres = new() {
                new WhereHelper(){
                     FiledName = nameof(rb_account_hk_Extend.Id),
                      FiledValue = model.Id,
                       OperatorEnum = OperatorEnum.Equal
                }
            };
            return accountRepository.Update(keyValues, wheres);
        }
    }
}
