﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EduSpider.Model.Extend
{
    /// <summary>
    /// 学员作业和考试结果
    /// </summary>
    public class ExamWorkResult
    {
        /// <summary>
        /// 行号
        /// </summary>
        public int RowNum { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateTime { get; set; }

        /// <summary>
        /// 类型(1-作业，2-考试，3-评语)
        /// </summary>
        public int ResultType { get; set; }

        /// <summary>
        /// 类型(1-作业，2-考试，3-评语)
        /// </summary>
        public string ResultTypeStr
        {
            get
            {
                string str = "";
                switch (this.ResultType)
                {
                    case 1:str = "作业"; break;
                    case 2: str = "考试"; break;
                    case 3: str = "评语"; break;
                }
                return str;
            }
        }

        /// <summary>
        /// 阶段评语
        /// </summary>
        public string Comment { get; set; }

        /// <summary>
        /// 标题
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        ///  评分机制(5-自定义，4-不评分，3-等第制，2-十分制，1-百分制)
        /// </summary>
        public int ScoreType { get; set; }

        /// <summary>
        /// 分数(ScoreType=5时使用)
        /// </summary>
        public decimal Score_Value { get; set; }

        /// <summary>
        /// 评分方式字符串
        /// </summary>
        public string ScoreTypeStr
        {
            get
            {
                string str = "";
                switch (this.ScoreType)
                {
                    case 1: str = "百分制"; break;
                    case 2: str = "十分制"; break;
                    case 3: str = "等第制"; break;
                    case 4: str = "不评分"; break;
                    case 5: str = "自定义"; break;
                }
                return str;
            }
        }

        /// <summary>
        /// 得分
        /// </summary>
        public decimal Score { get; set; }

        /// <summary>
        /// 得分率
        /// </summary>
        public decimal Score_p { get; set; }

        /// <summary>
        /// 作业状态状态
        /// </summary>
        public int HomeWorkStatus { get; set; }

        /// <summary>
        /// 作业状态字符串
        /// </summary>
        public string HomeWorkStatusStr
        {
            get
            {
                string str = "";
                switch (this.HomeWorkStatus)
                {
                    case 0: str = "未交作业"; break;
                    case 1: str = "未批阅"; break;
                    case 2: str = "已批阅"; break;
                }
                return str;
            }
        }

        /// <summary>
        /// 考试排名
        /// </summary>
        public int ExamRank { get; set; }

        /// <summary>
        /// 考试领先度
        /// </summary>
        public decimal ExamRankRate { get; set; }

        /// <summary>
        /// 教师姓名
        /// </summary>
        public string ThName { get; set; }
    }
}
