﻿using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using EduSpider.Repository.Base;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VTX.FW.DB.Dapper;

namespace EduSpider.Repository
{
    /// <summary>
    /// 课程老师关联仓储层
    /// </summary>
    public class CourseTeacherRepository : BaseRepository<RB_Course_Teacher>, ICourseTeacherRepository
    {
        /// <summary>
        /// 批量新增课程老师
        /// </summary>
        /// <param name="courses"></param>
        /// <returns></returns>
        public bool BatchSetCourseTeacherRepository(List<RB_Course_Teacher> courses)
        {
            bool flag;
            flag = base.BatchInsert(courses, isReplace: true);
            return flag;
        }

        /// <summary>
        /// 获取老师课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Teacher_Extend> GetTeacherCourseListRepository(CourseQuery query)
        {
            var parameters = new DynamicParameters();
            StringBuilder builder = new();
            builder.AppendFormat(@"
SELECT A.*,B.courseName,B.teacherId,B.teacherName,B.teacherLogo,B.CoverImg,B.courseStatus,B.completeNum,B.totalClassNum
FROM RB_Course_Teacher AS A INNER JOIN  RB_Course AS B ON A.courseId=B.courseId
WHERE 1=1
");
            if (query != null)
            {

                if (query.CourseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Course_Student.courseId), query.CourseId);
                }
                if (!string.IsNullOrWhiteSpace(query.TeacherIds))
                {
                    builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Course_Student.uid), query.TeacherIds);
                }
                if (query.QCourseState > 0)
                {
                    //进行中
                    if (query.QCourseState == 1)
                    {
                        builder.AppendFormat(" AND B.{0} IN({1}) AND B.totalClassNum<>B.completeNum ", nameof(RB_Course.CourseStatus), 1);
                    }
                    //已完成
                    if (query.QCourseState == 2)
                    {
                        builder.AppendFormat(" AND B.{0} IN({1}) ", nameof(RB_Course.CourseStatus), 3);
                    }
                }
            }
            builder.AppendFormat(" ORDER BY A.courseId DESC ");
            return Get<RB_Course_Teacher_Extend>(builder.ToString(), parameters).ToList();
        }
    }
}
