﻿
using EduSpider.IRepository;
using EduSpider.IServices;
using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using EduSpider.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.Attr;

namespace EduSpider.Services
{
    /// <summary>
    /// 课程服务实现
    /// </summary>
    public class CourseService : ICourseService
    {
        /// <summary>
        /// 学员课程仓储接口
        /// </summary>
        [Autowired]
        public ICourseStudentRepository CourseStudentRepository { get; set; }

        /// <summary>
        /// 学员家庭作业仓储接口
        /// </summary>
        [Autowired]
        public IStuHomeWorkRepository StuHomeWorkRepository { get; set; }

        /// <summary>
        /// 评语仓储层接口
        /// </summary>
        [Autowired]
        public ICommentRepository CommentRepository { get; set; }

        /// <summary>
        /// 老师课程关联仓储接口
        /// </summary>
        [Autowired]
        public ICourseTeacherRepository CourseTeacherRepository { get; set; }

        /// <summary>
        /// 作业仓储接口
        /// </summary>
        [Autowired]
        public IHomeWorkRepository HomeWorkRepository { get; set; }

        /// <summary>
        /// 学生考试仓储接口
        /// </summary>
        [Autowired]
        public IExam_ScoreRepository Exam_ScoreRepository { get; set; }


        /// <summary>
        /// 获取学员课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Student_Extend> GetStuCourseList(CourseQuery query)
        {
            var list = CourseStudentRepository.GetCourseStudentListRepository(query);
            return list;
        }

        /// <summary>
        /// 获取老师课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Teacher_Extend> GetTeacherCourseList(CourseQuery query)
        {
            var list = CourseTeacherRepository.GetTeacherCourseListRepository(query);
            return list;
        }

        /// <summary>
        /// 获取学员考试和家庭作业列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<object> GetStuWorkAndExamList(CourseQuery query)
        {
            List<object> list = new();
            List<ExamWorkResult> dataList = new();
            var homeWorkList = StuHomeWorkRepository.GetStuHomeWorkListRepository(query);
            if (homeWorkList != null && homeWorkList.Count > 0)
            {
                dataList.AddRange(homeWorkList);
            }
            var examList = Exam_ScoreRepository.GetExamScoreListRepository(query);
            if (examList != null && examList.Count > 0)
            {
                foreach (var item in examList)
                {
                    decimal score_p = 0;
                    if (item.ExamScore > 0)
                    {
                        score_p = Math.Round(item.TScore / item.ExamScore, 4);
                    }
                    dataList.Add(new ExamWorkResult()
                    {
                        ResultType = 2,
                        Title = item.ExamName,
                        CreateTime = item.ExamCreateTime,
                        Score = item.TScore,
                        Score_p = score_p,
                        ExamRank = item.Rank,
                        ExamRankRate = item.RankRate,
                    });
                }
            }

            if (dataList != null && dataList.Count > 0)
            {
                dataList = dataList.OrderBy(qitem => qitem.CreateTime).ToList();
                foreach (var item in dataList)
                {
                    object obj = new();
                    //家庭作业
                    if (item.ResultType == 1)
                    {
                        obj = new
                        {
                            item.Score,
                            Score_p = item.Score_p * 100,
                            item.ScoreType,
                            item.ScoreTypeStr,
                            item.Score_Value,
                            item.HomeWorkStatus,
                            item.HomeWorkStatusStr,
                        };
                    }
                    //考试
                    if (item.ResultType == 2)
                    {
                        obj = new
                        {
                            item.Score,
                            Score_p = item.Score_p * 100,
                            item.ExamRank,
                            item.ExamRankRate,
                        };
                    }
                    //评语
                    if (item.ResultType == 3)
                    {
                        obj = new
                        {
                            item.Comment
                        };
                    }

                    list.Add(new
                    {
                        item.ResultType,
                        item.ResultTypeStr,
                        item.Title,
                        CreateTime = VTX.FW.Helper.ConvertHelper.FormatTime(item.CreateTime, 2),
                        DataObj = obj
                    });
                }
            }
            return list;
        }

        /// <summary>
        /// 获取课程作业列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<object> GetCourseHomeWork(CourseQuery query)
        {
            List<object> result = new();
            var list = HomeWorkRepository.GetCourseHomeWorkListRepository(query);
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    string str = "";
                    if (item.Status == 0)
                    {
                        str = "未开始";
                    }
                    else if (item.Status == 1)
                    {
                        str = "进行中";
                    }
                    else if (item.Status == 2)
                    {
                        str = "已结束";
                    }
                    result.Add(new
                    {
                        HomeWorkId = item.Homework_id,
                        HomeWorkTitle = item.Homework_title,
                        item.Status,
                        StatusStr = str,
                        StuNum = item.Num,
                        SubmitNum = item.Cnum,
                        ReviewNum = item.Rnum,
                        ExcellentNum = item.Cream_num
                    });
                }
            }
            return result;
        }
    }
}
