﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Text;
using System.Text.RegularExpressions;
using System.Linq;

namespace EduSpider.Utility.Data
{
    /// <summary>
    /// 学生成绩导入帮助类
    /// </summary>
    public class StuExamScoreHelper
    {
        /// <summary>
        /// 根据Excel文件获取列表
        /// </summary>
        /// <param name="filePath"></param>
        /// <returns></returns>
        public static List<ExamQuestionModel> GetStuExamScoreData(string filePath, out List<StuScoreModel> StuList)
        {
            StuList = new List<StuScoreModel>();            
            var dt = NPOIHelper.ImportExcelToDatatable(filePath, 0, 0, true);
            List<ExamQuestionModel> EQList = new List<ExamQuestionModel>();
            if (dt != null && dt.Rows.Count > 0)
            {
                //先抓取 题目列表
                for (var i = 1; i < 1000; i++)
                {
                    if (dt.Columns.Contains(i.ToString()))
                    {
                        EQList.Add(new ExamQuestionModel()
                        {
                            Id = i,
                            Difficulty = dt.Rows[0][i.ToString()].ToString(),
                            KnowledgePoint = dt.Rows[1][i.ToString()].ToString(),
                            Module = dt.Rows[2][i.ToString()].ToString(),
                            Score = Convert.ToDecimal(dt.Rows[3][i.ToString()].ToString())
                        });
                    }
                    else
                    {
                        break;
                    }
                }
                if (EQList.Any())
                {
                    int totalCount = dt.Rows.Count;
                    //从第5行 开始  是学生
                    for (var i = 4; i < totalCount; i++)
                    {
                        foreach (var item in EQList)
                        {
                            //先装姓名
                            StuList.Add(new StuScoreModel()
                            {
                                Name = dt.Rows[i]["题号"].ToString().Trim(),
                                Id = item.Id,
                                Score = Convert.ToDecimal(dt.Rows[i][item.Id.ToString()].ToString())
                            });
                        }
                        if (i < totalCount - 1)
                        {
                            //总分  排名  百分比排名
                            StuList.Add(new StuScoreModel()
                            {
                                Name = dt.Rows[i]["题号"].ToString().Trim(),
                                Id = -1,
                                Score = Convert.ToDecimal(dt.Rows[i]["总分"].ToString())
                            });
                            StuList.Add(new StuScoreModel()
                            {
                                Name = dt.Rows[i]["题号"].ToString().Trim(),
                                Id = -2,
                                Score = Convert.ToDecimal(dt.Rows[i]["排名"].ToString())
                            });
                            StuList.Add(new StuScoreModel()
                            {
                                Name = dt.Rows[i]["题号"].ToString().Trim(),
                                Id = -3,
                                Score = Convert.ToDecimal(dt.Rows[i]["百分比排名"].ToString())
                            });
                        }
                    }
                }
            }
            return EQList;
        }
    }

    /// <summary>
    /// 考题
    /// </summary>
    public class ExamQuestionModel {
        /// <summary>
        /// 题目编号
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 难度
        /// </summary>
        public string Difficulty { get; set; }

        /// <summary>
        /// 知识点
        /// </summary>
        public string KnowledgePoint{ get; set; }

        /// <summary>
        /// 归属模块
        /// </summary>
        public string Module { get; set; }

        /// <summary>
        /// 分数
        /// </summary>
        public decimal Score { get; set; }
    }

    /// <summary>
    /// 学生成绩
    /// </summary>
    public class StuScoreModel { 

        /// <summary>
        /// 学生姓名
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 考题编号
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 得分
        /// </summary>
        public decimal Score { get; set; }
    }
}
