﻿using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.Config;
using VTX.FW.DB;

namespace EduSpider.IRepository
{
    /// <summary>
    /// 课程评价配置仓储接口
    /// </summary>
    public interface ICourseCommentRepository : IDBRepository<RB_Course_Comment>, IDependency
    {
        /// <summary>
        /// 批量新增修改课程评价
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCourseCommentRepository(RB_Course_Comment_Extend model);

        /// <summary>
        /// 获取课程评价配置列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Comment_Extend> GetCourseCommentListRepository(CourseQuery query);

        /// <summary>
        /// 根据编号删除课程评价
        /// </summary>
        /// <param name="Ids"></param>
        /// <returns></returns>
        public bool DeleteCourseCommentRepository(string Ids);
    }
}
