﻿using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.Config;

namespace EduSpider.IServices
{
    /// <summary>
    /// 课程服务层接口
    /// </summary>
    public interface ICourseService : IDependency
    {
        /// <summary>
        /// 获取学员课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Student_Extend> GetStuCourseList(CourseQuery query);


        /// <summary>
        /// 获取学员考试和家庭作业列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<object> GetStuWorkAndExamList(CourseQuery query);

        /// <summary>
        /// 获取老师课程列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Teacher_Extend> GetTeacherCourseList(CourseQuery query);

        /// <summary>
        /// 获取课程作业列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<object> GetCourseHomeWork(CourseQuery query);

        /// <summary>
        /// 获取作业详情
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<object> GetHomeWorkDetails(CourseQuery query);

        /// <summary>
        /// 新增修改课程评价配置
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCourseComment(RB_Course_Comment_Extend model);

        /// <summary>
        /// 获取课程评价配置列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Course_Comment_Extend> GetCourseCommentList(CourseQuery query);


        /// <summary>
        /// 根据评价编号删除课程评价配置
        /// </summary>
        /// <param name="Ids"></param>
        /// <returns></returns>
        public bool DeleteCourseComment(string Ids);

        /// <summary>
        /// 根据编号删除课程评价详情配置
        /// </summary>
        /// <param name="DetailIds"></param>
        /// <returns></returns>
        public bool DeleteCourseCommentDetail(string DetailIds);

        /// <summary>
        /// 新增修改学员评价
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetStuComment(RB_Stu_Comment model);
    }
}
