﻿using EduSpider.IServices;
using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.WebApi.Controllers.Base;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json.Linq;
using System.Collections.Generic;
using VTX.FW.Api;
using VTX.FW.Attr;
using VTX.FW.Helper;

namespace EduSpider.WebApi.Controllers
{
    /// <summary>
    /// 老师相关控制器
    /// </summary>
    public class TeacherController : BaseController
    {

        /// <summary>
        /// 课程仓储接口
        /// </summary>
        [Autowired]
        public ICourseService CourseService { get; set; }

        /// <summary>
        /// 获取老师课程列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult GetTeacherCourse()
        {
            var query = new Model.Query.CourseQuery()
            {
                TeacherIds = base.BaseUserId.ToString(),
                KeyWords = base.ReqParameters.GetString("KeyWords"),
            };
            //全部课程
            List<object> AllCourseList = new();
            //已结课
            List<object> FinishList = new();
            //进行中
            List<object> NotFinishList = new();
            var list = CourseService.GetTeacherCourseList(query);

            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    var obj = new
                    {
                        item.courseId,
                        item.CourseName,
                        item.CoverImg,
                        item.CompleteNum,
                        item.TotalClassNum,
                        item.TeacherName,
                    };
                    AllCourseList.Add(obj);
                    if (item.CourseStatus == 3)
                    {
                        FinishList.Add(obj);
                    }
                    if (item.CourseStatus == 1 && item.CompleteNum != item.TotalClassNum)
                    {
                        NotFinishList.Add(obj);
                    }
                }
            }
            var result = new { AllCourseList, FinishList, NotFinishList };
            return ApiResult.Success(data: result);
        }

        /// <summary>
        /// 获取课程学员列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult GetCourseStu()
        {
            var query = new Model.Query.CourseQuery()
            {
                CourseId = base.ReqParameters.GetInt("courseId")
            };
            List<object> result = new();
            var list = CourseService.GetStuCourseList(query);
            if (list != null && list.Count > 0)
            {
                foreach (var item in list)
                {
                    result.Add(new
                    {
                        StuId = item.uid,
                        StuName = item.name,
                        StuAccount = item.account
                    });
                }
            }
            return ApiResult.Success(data: result);
        }

        /// <summary>
        /// 获取课程作业列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult GetCourseHomeWork()
        {
            var query = new Model.Query.CourseQuery()
            {
                CourseId = base.ReqParameters.GetInt("courseId")
            };
            var list = CourseService.GetCourseHomeWork(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 获取课程家庭作业详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult GetHomeWorkDetails()
        {
            var query = new Model.Query.CourseQuery()
            {
                HomeWorkId = base.ReqParameters.GetInt("HomeWorkId")
            };
            var list = CourseService.GetHomeWorkDetails(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 获取课程评语列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult GetCourseCommentList()
        {
            var query = new Model.Query.CourseQuery()
            {
                CourseId = base.ReqParameters.GetInt("CourseId")
            };
            var list = CourseService.GetCourseCommentList(query);
            return ApiResult.Success(data: list);
        }

        /// <summary>
        /// 新增可以课程评语
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult SetCourseComment()
        {
            var model = new RB_Course_Comment_Extend()
            {
                Id = base.ReqParameters.GetInt("Id"),
                CourseId = base.ReqParameters.GetInt("CourseId"),
                Title = base.ReqParameters.GetString("Title"),
                ShowType = base.ReqParameters.GetInt("ShowType"),
            };
            model.CreateBy = base.BaseUserId;
            model.CreateTime = System.DateTime.Now;
            model.Status = 0;
            model.CommentDetails = new List<RB_Course_CommentDetails_Extend>();
            string commentDetails = base.ReqParameters.GetString("CommentDetails");
            if (!string.IsNullOrWhiteSpace(commentDetails))
            {
                JArray array = JArray.Parse(commentDetails);
                if (array != null && array.Count > 0)
                {
                    foreach (var jItem in array)
                    {
                        var sObj = JObject.Parse(jItem.ToString());
                        var details = new RB_Course_CommentDetails_Extend()
                        {
                            DetailId = sObj.GetInt("DetailId"),
                            CourseCommentId = sObj.GetInt("CourseCommentId"),
                            StartNum = sObj.GetDecimal("StartNum"),
                            EndNum = sObj.GetDecimal("EndNum"),
                            Info = sObj.GetString("Info"),
                            Status = 0,
                            CreateBy = base.BaseUserId,
                            CreateTime = System.DateTime.Now,
                            UpdateBy = base.BaseUserId,
                            UpdateTime = System.DateTime.Now,
                        };
                        model.CommentDetails.Add(details);
                    }
                }
            }
            var flag = CourseService.SetCourseComment(model);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 删除课程评语
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult RemoveCourseComment()
        {
            string Ids = base.ReqParameters.GetString("Ids");
            var flag = CourseService.DeleteCourseComment(Ids);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }

        /// <summary>
        /// 根据编号删除课程评价详情配置
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public ApiResult RemoveCourseCommentDetail()
        {
            string DetailIds = base.ReqParameters.GetString("DetailIds");
            var flag = CourseService.DeleteCourseCommentDetail(DetailIds);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }


        [HttpPost]
        [HttpGet]
        /// <summary>
        /// 新增修改学员评价
        /// </summary>
        /// <returns></returns>
        public ApiResult SetStuComment()
        {
            var model = new RB_Stu_Comment()
            {
                Id=base.ReqParameters.GetInt("Id"),
                HomeWorkId=base.ReqParameters.GetInt("HomeWorkId"),
                StuUid=base.ReqParameters.GetInt("StuUid"),
                CourseId=base.ReqParameters.GetInt("CourseId"),
                Times=base.ReqParameters.GetInt("Times"),
                Info=base.ReqParameters.GetString("Info"),
                CreateType=base.ReqParameters.GetInt("CreateType"),
            };
            model.CreateTime = System.DateTime.Now;
            model.CreateBy = base.BaseUserId;
            model.CreateByName = base.UserInfo.AccountName;
            var flag = CourseService.SetStuComment(model);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }
    }
}
