﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Repository;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using VTX.FW.Helper;

namespace EduSpider.Spiders.ClassInRule
{
    /// <summary>
    /// 学生作业
    /// </summary>
    public class HomeWorkManager
    {
        /// <summary>
        /// 获取学生作业列表
        /// </summary>
        public static async void RunHomeWork(string cookie)
        {
            int perpage = 20;
            var pageCount = 1;
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            string queryStr = "page={0}&perpage={1}&analysis=1";
            string paramStr = string.Format(queryStr, pageCount, perpage);
            var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
            IHomeWorkRepository homeWorkRepository = new HomeWorkRepository();
            int totalCount = 0;
            Console.WriteLine(string.Format("开始第{0}次获取家庭作业", pageCount));

            string url = "https://console.eeo.cn/saasajax/homework.ajax.php?action=getHomeworkList";
            var response = await request.PostAsync(url, content);
            var result = response.Content.ReadAsStringAsync().Result;
            if (!string.IsNullOrWhiteSpace(result))
            {
                JObject rootObj = JObject.Parse(result);
                if (!string.IsNullOrWhiteSpace(rootObj.GetString("data")))
                {
                    JObject dataObj = JObject.Parse(rootObj.GetString("data"));
                    var totalNum = dataObj.GetInt("total");
                    var tempList = ParseJson(dataObj.GetString("list"));
                    if (tempList != null && tempList.Count > 0)
                    {
                        homeWorkRepository.BatchSetHomeWorkRepository(tempList);
                        totalCount += tempList.Count;
                        Console.WriteLine(string.Format("第{0}次,导入完成{1}条.", pageCount, totalCount));
                        foreach (var item in tempList)
                        {
                            RunStuHomeWork(cookie, item.Homework_id, item.Course_id);
                        }
                    }
                    if (totalNum % perpage == 0)
                    {
                        pageCount = totalNum / perpage;
                    }
                    else
                    {
                        pageCount = totalNum / perpage + 1;
                    }

                    if (totalNum > perpage)
                    {
                        for (var i = 2; i <= pageCount; i++)
                        {
                            Thread.Sleep(1000 * 2);
                            Console.WriteLine(string.Format("第{0}/{1}次获取课程数据", i, pageCount));
                            paramStr = string.Format(queryStr, i, perpage);
                            var sub_content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
                            var sub_response = await request.PostAsync(url, sub_content);

                            var sub_result = sub_response.Content.ReadAsStringAsync().Result;
                            if (!string.IsNullOrWhiteSpace(sub_result))
                            {
                                JObject sub_rootObj = JObject.Parse(sub_result);
                                if (!string.IsNullOrWhiteSpace(sub_rootObj.GetString("data")))
                                {
                                    JObject sub_dataObj = JObject.Parse(sub_rootObj.GetString("data"));
                                    var subtempList = ParseJson(sub_dataObj.GetString("list"));
                                    if (subtempList != null && subtempList.Count > 0)
                                    {
                                        homeWorkRepository.BatchSetHomeWorkRepository(subtempList);
                                        totalCount += subtempList.Count;
                                        Console.WriteLine(string.Format("第{0}次,导入完成{1}条.", i, totalCount));
                                        foreach (var sItem in subtempList)
                                        {
                                            RunStuHomeWork(cookie, sItem.Homework_id, sItem.Course_id);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

        }

        /// <summary>
        /// JSON字符串转课程列表
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<RB_HomeWork> ParseJson(string data)
        {
            List<RB_HomeWork> list = new();
            if (!string.IsNullOrWhiteSpace(data))
            {
                JArray courseArray = JArray.Parse(data);
                if (courseArray != null && courseArray.Count > 0)
                {
                    foreach (var jItem in courseArray)
                    {
                        JObject homeObj = JObject.Parse(jItem.ToString());
                        list.Add(new RB_HomeWork()
                        {
                            Homework_id = homeObj.GetInt("homework_id"),
                            Homework_title = homeObj.GetString("homework_title"),
                            Homework_share_key = homeObj.GetString("homework_share_key"),
                            Course_id = homeObj.GetInt("course_id"),
                            Course_name = homeObj.GetString("course_name"),
                            Start_time = ConvertHelper.UnixToDateTime(homeObj.GetInt("start_time")),
                            End_time = ConvertHelper.UnixToDateTime(homeObj.GetInt("end_time")),
                            Status = homeObj.GetInt("status"),
                            Is_del = homeObj.GetInt("is_del"),
                            Is_open = homeObj.GetInt("is_open"),
                            Open_type = homeObj.GetInt("open_type"),
                            Is_revise = homeObj.GetInt("is_revise"),
                            Num = homeObj.GetInt("num"),
                            Cream_num = homeObj.GetInt("cream_num"),
                            Revised_num = homeObj.GetInt("revised_num"),
                            Rnum = homeObj.GetInt("rnum"),
                            Cnum = homeObj.GetInt("cnum"),
                            School_uid = homeObj.GetInt("school_uid"),
                            Score_type = homeObj.GetInt("score_type"),
                            Score_value = homeObj.GetDecimal("score_value"),
                            Teacher_account = homeObj.GetString("teacher_account"),
                            Teacher_name = homeObj.GetString("teacher_name"),
                            Teacher_uid = homeObj.GetInt("teacher_uid"),
                            Th_cancel = homeObj.GetString("th_cancel"),
                            Add_time = ConvertHelper.UnixToDateTime(homeObj.GetInt("add_time")),
                            Update_time = ConvertHelper.UnixToDateTime(homeObj.GetInt("update_time")),
                            Ref_num = homeObj.GetInt("ref_num"),
                            Refc_num = homeObj.GetInt("refc_num"),
                            Av_score = homeObj.GetDecimal("av_score"),
                            Max_score = homeObj.GetDecimal("max_score"),
                            Min_score = homeObj.GetDecimal("min_score"),
                        });
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 获取学生提交作业数据
        /// </summary>
        /// <param name="cookie"></param>
        /// <param name="homework_id"></param>
        public static async void RunStuHomeWork(string cookie, int homework_id,int courseId)
        {
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            IStuHomeWorkRepository stuHomeWorkRepository = new StuHomeWorkRepository();
            ICourseStudentRepository courseStudentRepository = new CourseStudentRepository();
            string stuIds = "";
            var courseStuList = courseStudentRepository.GetCourseStudentListRepository(new Model.Query.CourseQuery() { CourseId = courseId });
            if (courseStuList != null)
            {
                stuIds = string.Join(",", courseStuList.Select(qitem => qitem.uid));
            }
            string queryStr = "page=1&perpage=100000&homework_id=[{0}]&course_id=[{1}]&is_del=[0]&student_uid=[{2}]&by=2";
            
            string paramStr = string.Format(queryStr, homework_id, courseId, stuIds);
            var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
            Console.WriteLine(string.Format("开始获取{0}作业学员数据", homework_id));
            string url = "https://console.eeo.cn/saasajax/homework.ajax.php?action=getStudentsHomeworkList";
            var response = await request.PostAsync(url, content);
            var sutHomeWorkResult = response.Content.ReadAsStringAsync().Result;
            List<RB_Stu_HomeWork> list = new();
            if (!string.IsNullOrWhiteSpace(sutHomeWorkResult))
            {
                JObject stuHomeRootObj = JObject.Parse(sutHomeWorkResult);
                if (!string.IsNullOrWhiteSpace(stuHomeRootObj.GetString("data")))
                {
                    JObject stuHomeDataObj = JObject.Parse(stuHomeRootObj.GetString("data"));
                    if (!string.IsNullOrWhiteSpace(stuHomeDataObj.GetString("list")))
                    {
                        JArray stuHomeArray = JArray.Parse(stuHomeDataObj.GetString("list"));
                        if (stuHomeArray != null && stuHomeArray.Count > 0)
                        {
                            foreach (var rootItem in stuHomeArray)
                            {
                                JObject stuItemObj = JObject.Parse(rootItem.ToString());
                                if (!string.IsNullOrWhiteSpace(stuItemObj.GetString("students")))
                                {
                                    JArray stuListArray = JArray.Parse(stuItemObj.GetString("students"));
                                    if (stuListArray != null && stuListArray.Count > 0)
                                    {
                                        foreach (var sItem in stuListArray)
                                        {
                                            JObject lastObj = JObject.Parse(sItem.ToString());
                                            list.Add(new RB_Stu_HomeWork()
                                            {
                                                stu_homework_id = lastObj.GetInt("stu_homework_id"),
                                                admire = lastObj.GetString("admire"),
                                                cancel = lastObj.GetString("cancel"),
                                                correct = lastObj.GetDecimal("correct"),
                                                wrong = lastObj.GetInt("wrong"),
                                                course_id = lastObj.GetInt("course_id"),
                                                is_cream = lastObj.GetInt("is_cream"),
                                                emend = lastObj.GetInt("emend"),
                                                homework_id = lastObj.GetInt("homework_id"),
                                                homework_share_key = lastObj.GetString("homework_share_key"),
                                                is_draft = lastObj.GetInt("is_draft"),
                                                is_reform = lastObj.GetInt("is_reform"),
                                                is_revised = lastObj.GetInt("is_revised"),
                                                is_startd = lastObj.GetInt("is_startd"),
                                                readover = lastObj.GetString("readover"),
                                                ref_time= ConvertHelper.UnixToDateTime(lastObj.GetInt("ref_time")),
                                                comment = lastObj.GetString("comment"),
                                                reform = lastObj.GetString("reform"),
                                                school_uid = lastObj.GetInt("school_uid"),
                                                score = lastObj.GetDecimal("score"),
                                                score_p = lastObj.GetDecimal("score_p"),
                                                score_type = lastObj.GetInt("score_type"),
                                                show_time = ConvertHelper.UnixToDateTime(lastObj.GetInt("show_time")),
                                                status = lastObj.GetInt("status"),
                                                stu_homework_share_key= lastObj.GetString("stu_homework_share_key"),
                                                student_account = lastObj.GetString("student_account"),
                                                student_name = lastObj.GetString("student_name"),
                                                student_uid = lastObj.GetInt("student_uid"),
                                                th_account = lastObj.GetString("th_account"),
                                                th_cancel = lastObj.GetString("th_cancel"),
                                                th_name = lastObj.GetString("th_name"),
                                                th_num = lastObj.GetInt("th_num"),
                                                th_time = ConvertHelper.UnixToDateTime(lastObj.GetInt("th_time")),
                                                th_uid = lastObj.GetInt("th_uid"),
                                                add_time = ConvertHelper.UnixToDateTime(lastObj.GetInt("add_time")),
                                                update_time = ConvertHelper.UnixToDateTime(lastObj.GetInt("update_time")),
                                            });
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (list != null && list.Count > 0)
            {
                stuHomeWorkRepository.BatchSetStuHomeWorkRepository(list);
            }
        }


    }
}
