﻿using OpenCvSharp;
using OpenQA.Selenium;
using OpenQA.Selenium.Chrome;
using OpenQA.Selenium.Interactions;
using System;
using System.IO;
using System.Net;
using System.Net.Http;
using System.Threading;
using System.Threading.Tasks;

namespace TicketSpider.Spiders.ClassInRule
{
    public class ClassInAccountManager
    {

        private static readonly object  lockerSafe= new();

        private static string _loginCookies = "";//"locationArgumentLang=zh-CN; sensorsdata2015jssdkcross={\"distinct_id\":\"12780052\",\"first_id\":\"180e074a47f92f-06489d0bb8915b-6b3e555b-1327104-180e074a4805d2\",\"props\":{\"$latest_traffic_source_type\":\"直接流量\",\"$latest_search_keyword\":\"未取到值_直接打开\",\"$latest_referrer\":\"\"},\"$device_id\":\"180e074a47f92f-06489d0bb8915b-6b3e555b-1327104-180e074a4805d2\"}; _eeos_uid=12780052; _eeos_useraccount=18140082327; _eeos_userlogo=/upload/images/20200126/709df9532bee722f2268_70.jpg; _eeos_domain=.eeo.cn; _eeos_sid=12780052; _eeos_nsid=kspGu2gfMu+U2EFgLpSGyg==; __tk_id=5792ca4f7a6655c40c4431fbdb729da4; PHPSESSID=l5aanmebp5lvpcbg630ccfha37; _eeos_traffic=EqlIOFq4S2hz5FTTtHzNUViBYcWCixrJYMCF6Y5yJuD8eq8ZwPvVSHMvUkLFA5lzNoaTrDBpGhEY7ykZ9lwMAsNJoNiDt2xKQBr9csRmiBE=";

        private static bool _openHeartTimer = false;

        public static string _userId = String.Empty;

        public static string GetInstance()
        {
            if (string.IsNullOrEmpty(_loginCookies))
            {
                lock (lockerSafe)
                {
                    if (string.IsNullOrEmpty(_loginCookies)) 
                    {
                        _loginCookies = string.Empty;
                        
                        var cnt = 0;
                        while (cnt<4)
                        {
                            cnt++;
                            var result = RunAsync();
                            if (result && !_openHeartTimer)
                            {
                                _openHeartTimer = true;
                                Task.Run(() => HeartLine());
                                break;
                            }
                            else 
                            {
                                Console.WriteLine("开始重新尝试登录");
                                Thread.Sleep(2000);
                            }
                        }
                    }
                }  
            }
            return _loginCookies;
        }

        

        public static bool RunAsync()
        {
            var flag = false;
            IWebElement inputEle;
            IWebElement pwdEle;
            var option = new ChromeOptions();
            option.AddArgument("--incognito");
            option.AddArgument("headless");
            option.AddArgument("disable-infobars");
            option.AddArgument("window-size=1920,1080");
            option.AddArgument("user-agent=Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/95.0.4638.69 Safari/537.36");
            ChromeDriverService service = ChromeDriverService.CreateDefaultService(Environment.CurrentDirectory);
            service.HideCommandPromptWindow = true;
            option.PageLoadStrategy = PageLoadStrategy.Eager;
            IWebDriver driver = new ChromeDriver(service, option);
            
            try
            {
                
                driver.Navigate().GoToUrl($"https://www.eeo.cn/cn/login");
                driver.Manage().Timeouts().PageLoad=TimeSpan.FromSeconds(15);

                inputEle = driver.FindElement(By.Name("phoneNum"));
                pwdEle = driver.FindElement(By.Name("loginPwd"));

                
                if (inputEle != null && pwdEle!=null) 
                {
                    inputEle.SendKeys("18140082327");
                    pwdEle.SendKeys("ls123456");
                    var loginCount = 0;
                    var buttonEle = driver.FindElement(By.CssSelector(".submit-btn"));
                    Thread.Sleep(1000);
                    //开始登录
                    buttonEle.Click();
                    //开始模拟登录
                    while (true)
                    {
                        loginCount++;
                        Console.WriteLine($"正在进行第{loginCount}次模拟登录...");
                        var login = BeginSliderLoginHandler(ref driver);
                        if (login.IsCompleted)
                        {
                            driver.SwitchTo().DefaultContent();
                            Console.WriteLine($"操作完成，正在等待结果");
                            //睡眠1秒，等待跳转
                            Thread.Sleep(5 * 1000);
                            if (driver.Url.Contains("www.eeo.cn/cn/login"))
                            {
                                Console.WriteLine($"模拟登录失败，准备重新执行...");
                                IWebElement silderBoxEle = null;
                                try
                                {
                                    silderBoxEle = driver.FindElement(By.Id("reload"));
                                }
                                catch (Exception){}
                                if (silderBoxEle != null)
                                {
                                    silderBoxEle.Click();
                                }
                                if (loginCount == 4)
                                {
                                    Console.WriteLine("连续4次失败，请检查账号密码是否正确，系统执行完毕");
                                    break;
                                }
                            }
                            else
                            {
                                Thread.Sleep(3 * 1000);
                                //处理
                                foreach (var item in driver.Manage().Cookies.AllCookies)
                                {
                                    _loginCookies += item.Name + "=" + item.Value + ";";
                                }
                                _loginCookies = _loginCookies.Substring(0, _loginCookies.Length - 1);
                                flag = true;
                                break;
                            }
                        }
                        else 
                        {
                            Console.WriteLine("未知异常，程序退出");
                            break;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine($"获取cooki失败，{ex.Message}");
            }
            driver.Quit();
            Console.WriteLine("完成登录...");
            return flag;
            
        }

        public static Task BeginSliderLoginHandler(ref IWebDriver driver)
        {
           
            //等待滑块加载
            Thread.Sleep(5000);
            driver.SwitchTo().Frame(driver.FindElement(By.Id("tcaptcha_iframe")));
            ((IJavaScriptExecutor)driver).ExecuteScript("document.getElementById(\"slideBlock\").style.opacity = 0;");
            var bgPng = ((ITakesScreenshot)driver.FindElement(By.Id("slideBg"))).GetScreenshot();
            ((IJavaScriptExecutor)driver).ExecuteScript("document.getElementById(\"slideBlock\").style.opacity = 1;document.getElementById(\"slideBg\").style.opacity = 0;");
            var blockPng = ((ITakesScreenshot)driver.FindElement(By.Id("slideBlock"))).GetScreenshot();
            ((IJavaScriptExecutor)driver).ExecuteScript("document.getElementById(\"slideBg\").style.opacity = 1;");
            var dirpath = $"{Environment.CurrentDirectory}\\geetest";
            if (!Directory.Exists(dirpath))
            {
                Directory.CreateDirectory(dirpath);
            }
            var fileBgPath = $"{dirpath}\\{DateTime.Now.Ticks}.png";
            var fileBlockPath = $"{dirpath}\\{DateTime.Now.Ticks + 1}.png";
            bgPng.SaveAsFile(fileBgPath, ScreenshotImageFormat.Png);
            blockPng.SaveAsFile(fileBlockPath, ScreenshotImageFormat.Png);
           
                
            var bgX = GetBoundary(fileBgPath,fileBlockPath);
            Console.WriteLine($"读取背景缺口边界X坐标： {bgX}");

            Actions action = new(driver);
            var sliderButton = driver.FindElement(By.Id("tcaptcha_drag_button"));
            if (sliderButton != null)
            {
                ((IJavaScriptExecutor)driver).ExecuteScript("document.getElementById(\"slideBlock\").style.opacity = 1;");
                action.ClickAndHold(sliderButton).Build().Perform();
                #region 开始拟人移动
                var d1 = Math.Round(bgX * 0.8);
                var d2 = Math.Round(bgX * 0.1);
                var d3 = Math.Round(bgX * 0.1);
                action.MoveByOffset((int)d1, 1);
                Thread.Sleep(new Random().Next(100) + 150);
                action.MoveByOffset((int)d2, 1);
                Thread.Sleep(new Random().Next(100) + 150);
                action.MoveByOffset((int)d3, 1);
                action.MoveByOffset((bgX - (int)d1 - (int)d2 - (int)d3), 1);
                Thread.Sleep(2000);
                #endregion
                action.Release(sliderButton);
                action.Build().Perform();

                driver.SwitchTo().DefaultContent();
               

            }
            
            File.Delete(fileBgPath);
            File.Delete(fileBlockPath);
            return Task.CompletedTask;
        }

        private static int GetBoundary(string bg, string tp)
        { 
            var bgImg=Cv2.ImRead(bg);
            var tpImg=Cv2.ImRead(tp);

            var bgEdge = new Mat();
            Cv2.Canny(bgImg, bgEdge, 100, 200);
            var tpEdge = new Mat();
            Cv2.Canny(tpImg, edges: tpEdge, 100, 200);


            var bgPic = new Mat();
            Cv2.CvtColor(bgEdge, bgPic, ColorConversionCodes.GRAY2RGB);
            var tpPic = new Mat();
            Cv2.CvtColor(tpEdge, tpPic, ColorConversionCodes.GRAY2RGB);

            var res = new Mat();
            Cv2.MatchTemplate(bgPic,tpPic,res, TemplateMatchModes.CCoeffNormed);
            OpenCvSharp.Point minLoc = new OpenCvSharp.Point(), maxLoc = new OpenCvSharp.Point();
            Cv2.MinMaxLoc(res,out double minVal,out double maxVal,out minLoc,out maxLoc);

            var bt = new OpenCvSharp.Point(maxLoc.X+tpPic.Width,maxLoc.Y+tpPic.Height);
            Cv2.Rectangle(bgImg, maxLoc, bt, Scalar.Red, 2);
            var dirpath = $"{Environment.CurrentDirectory}\\geetest";
            Cv2.ImWrite($"{dirpath}\\{DateTime.Now.Ticks}.png",bgImg);

            return maxLoc.X-20;
        }

        private static void HeartLine()
        {
            while (_openHeartTimer)
            {
                var handler = new HttpClientHandler
                {
                    AllowAutoRedirect = false,
                    UseCookies = true,
                    CookieContainer = CreateCookie(),
                    AutomaticDecompression = DecompressionMethods.GZip,
                    ClientCertificateOptions = ClientCertificateOption.Automatic
                };
                var http = new HttpClient(handler);
                http.GetAsync("https://console.eeo.cn/saas/school/index.html#/fullPage/Index?lang=zh-CN");
                //TODO:检查是否需要重新登录
                Thread.Sleep(60 * 1000);
            }
        }

        public static void StopHeartLine()
        { 
            _openHeartTimer = false;
        }

        private static CookieContainer CreateCookie()
        {
            var uri = new Uri("https://console.eeo.cn");
            var cc = new CookieContainer();
            foreach (var str in _loginCookies.Split(';'))
            {
                cc.SetCookies(uri, str);
            }
            return cc;
        }
    }
}
