﻿using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using VTX.FW.Helper;

namespace EduSpider.Spiders.SchoolHouseKeeper
{
    /// <summary>
    /// 校管家课程关联
    /// </summary>
    public class SchoolCourseManager
    {
        /// <summary>
        /// 分页数据
        /// </summary>
        public class PageModel
        {
            public int PageIndex { get; set; }
            public int PageSize { get; set; }
        }

        /// <summary>
        /// 获取课程列表
        /// </summary>
        public static async void RunCourse(string cookie)
        {
            var pageModel = new PageModel
            {
                PageIndex = 1,
                PageSize = 10
            };
            int pageCount;
            string url = "https://tms11.xiaogj.com/api/Shift/Query";

            //var request=   Utility.SchoolHttpHelper.GenerateHttp(cookie);
            //string query = string.Format("PageIndex=1&PageSize=10");
            //var content = new StringContent(VTX.FW.Helper.JsonHelper.Serialize(pageModel), System.Text.Encoding.GetEncoding("UTF-8"), "application/json");
            //var response = await request.PostAsync(url, content);
            //var result12 = response.Content.ReadAsStringAsync().Result;
            //Console.WriteLine("111" + result12);

            string result;
            result = Utility.SchoolHttpHelper.HttpPost(url, VTX.FW.Helper.JsonHelper.Serialize(pageModel), "application/json", cookie); ;
            List<SchoolCourseItem> list = new List<SchoolCourseItem>();
            if (!string.IsNullOrEmpty(result))
            {
                JObject jobj = JObject.Parse(result);
                pageCount = jobj.GetInt("PageCount");
                list.AddRange(ParseJson(jobj.GetString("Data")));
                Console.WriteLine(string.Format("已完成 页{0}/{1},数据 {2}/{3}", pageModel.PageIndex, pageCount, pageModel.PageSize * pageModel.PageIndex, list.Count));
                if (pageCount > pageModel.PageIndex)
                {
                    Random random = new Random();
                    for (var i = 2; i <= pageCount; i++)
                    {
                        var num = random.Next(1, 10);
                        Thread.Sleep(1000 * num);
                        pageModel.PageIndex = i;
                        string subResult = Utility.SchoolHttpHelper.HttpPost(url, VTX.FW.Helper.JsonHelper.Serialize(pageModel), "application/json", cookie);
                        if (!string.IsNullOrEmpty(subResult))
                        {
                            JObject subObj = JObject.Parse(subResult);
                            list.AddRange(ParseJson(subObj.GetString("Data")));
                        }
                        Console.WriteLine(string.Format("已完成 页{0}/{1},数据 {2}/{3}", pageModel.PageIndex, pageCount, pageModel.PageSize * pageModel.PageIndex, list.Count));
                    }
                }
            }
            Console.WriteLine("result:" + VTX.FW.Helper.JsonHelper.Serialize(list));

        }

        /// <summary>
        /// 解析JSON
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<SchoolCourseItem> ParseJson(string data)
        {
            List<SchoolCourseItem> list = new List<SchoolCourseItem>();
            if (!string.IsNullOrEmpty(data))
            {
                JArray courseArray = JArray.Parse(data);
                if (courseArray != null && courseArray.Count > 0)
                {
                    foreach (var item in courseArray)
                    {
                        JObject cObj = JObject.Parse(item.ToString());

                        var model = new SchoolCourseItem()
                        {
                            ID = cObj.GetString("ID"),
                            Name = cObj.GetString("Name"),
                            IsOneToOne = cObj.GetInt("IsOneToOne"),
                        };
                        list.Add(model);
                    }
                }
            }
            return list;
        }
    }

    /// <summary>
    /// 校管家课程实体
    /// </summary>
    public class SchoolCourseItem
    {
        /// <summary>
        /// 课程编号GUID
        /// </summary>
        public string ID { get; set; }

        /// <summary>
        /// 课程名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 是否一对一
        /// </summary>
        public int IsOneToOne { get; set; }
    }
}
