﻿using EduSpider.Model.Entity;
using EduSpider.Model.Extend;
using EduSpider.Model.Query;
using System.Collections.Generic;
using VTX.FW.Config;
using VTX.FW.DB;

namespace EduSpider.IRepository
{
    /// <summary>
    /// 学生作业仓储层接口
    /// </summary>
    public interface IStuHomeWorkRepository : IDBRepository<RB_Stu_HomeWork>, IDependency
    {
        /// <summary>
        /// 批量添加学生家庭作业
        /// </summary>
        /// <param name="homeWorks"></param>
        /// <returns></returns>
        public bool BatchSetStuHomeWorkRepository(List<RB_Stu_HomeWork> homeWorks);

        /// <summary>
        /// 创建课程作业评论
        /// </summary>
        /// <param name="CourseId">课程编号</param>
        /// <returns></returns>
        public List<ExamWorkResult> CreateHomeWorkCommentRepository(int CourseId);

        /// <summary>
        /// 获取学生作业列表
        /// </summary>
        /// <returns></returns>
        public List<ExamWorkResult> GetStuHomeWorkListRepository(CourseQuery query);

        /// <summary>
        /// 获取家庭作业列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Stu_HomeWork_Extend> GetStuHomeWorkDetailsListRepository(CourseQuery query);
    }
}
