﻿using EduSpider.IRepository;
using EduSpider.Model.Entity;
using EduSpider.Repository;
using EduSpider.Utility;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Net.Http;
using System.Text;
using VTX.FW.Helper;

namespace EduSpider.Spiders.ClassInRule
{
    public class StudentManager
    {

        private static readonly IStudentRepository courseRepository = new StudentRepository();

        public async void RunAsync(string cookie)
        {
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            int pageIndex = 1, pageCount = 1, pageSize=500;

            while (pageIndex <= pageCount) 
            {
                Console.WriteLine($"正在查询第{pageIndex}-{pageSize}页学员信息");
                var paramStr = $"page={pageIndex}&perpage={pageSize}&isdel=0";
                var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
                var response = await request.PostAsync("https://console.eeo.cn/saasajax/student.ajax.php?action=getSchoolStudentListByPage", content);

                var resultStr = response.Content.ReadAsStringAsync().Result ?? string.Empty;
                var result = resultStr.TryToJObject();
                
                if (result.flag)
                {
                    var data = (result.val.ContainsKey("data") ? result.val["data"] : new JObject()) as JObject;
                    if (data.ContainsKey("totalStudentNum")) {
                        #region 更新PageCount

                        if (pageIndex == 1)
                        {
                            pageCount = (int)Math.Ceiling(data.GetDecimal("totalStudentNum") / pageSize);
                        }

                        #endregion

                        #region 组装实体

                        var stus = new List<RB_Student>();
                        var stuArray = (data["studentList"] as JArray);
                        foreach (JObject x in stuArray)
                        {
                            stus.Add(new RB_Student()
                            {
                                AddTime = ConvertHelper.UnixToDateTime(x.GetString("addTime")),
                                StudentAccount=x.GetString("studentAccount"),
                                Isdel= x.GetInt("isdel",0),
                                IsGroup = x.GetInt("isGroup", 0),
                                StudId = x.GetInt("studId", 0),
                                Progress = x.GetString("progress"),
                                PublicResourceStatus = x.GetInt("publicResourceStatus", 0),
                                ServeState = x.GetInt("serveState", 0),
                                StudentName = x.GetString("studentName"),
                                StudentUid = x.GetInt("studentUid", 0),
                                Stuno = x.GetString("stuno"),
                            });
                        }
                        courseRepository.BatchSetStudent(stus);
                        Console.WriteLine($"已导入第{pageIndex}-{pageSize}页学员信息");
                        #endregion
                    }
                }
                pageIndex++;
            }

            Console.WriteLine("学员同步完成");

        }

    }
}
