﻿using EduSpider.Model.Entity;
using EduSpider.Repository;
using EduSpider.Utility.Enum;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading;
using VTX.FW.Helper;

namespace EduSpider.Spiders.ClassInRule
{
    /// <summary>
    /// 课程关联
    /// </summary>
    public class CourseManager
    {
        /// <summary>
        /// 获取课程列表
        /// </summary>
        public static async void RunCourse(string cookie)
        {
            int perpage = 20;
            var pageCount = 1;
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            string queryStr = "page={0}&perpage={1}";
            string paramStr = string.Format(queryStr, pageCount, perpage);
            var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
            ICourseRepository courseRepository = new CourseRepository();
            int totalCount = 0;
            Console.WriteLine(string.Format("开始第{0}次获取课程数据", pageCount));
            VTX.FW.Helper.LogHelper.WriteInfo("RunCourse", string.Format("开始第{0}次获取课程数据", pageCount));
            string url = "https://console.eeo.cn/saasajax/course.ajax.php?action=getCourseList";
            var response = await request.PostAsync(url, content);
            var result = response.Content.ReadAsStringAsync().Result;
            if (!string.IsNullOrWhiteSpace(result))
            {
                JObject rootObj = JObject.Parse(result);
                if (!string.IsNullOrWhiteSpace(rootObj.GetString("data")))
                {
                    JObject dataObj = JObject.Parse(rootObj.GetString("data"));
                    var totalNum = dataObj.GetInt("totalCourseNum");
                    var tempList = ParseJson(dataObj.GetString("courseList"));
                    if (tempList != null && tempList.Count > 0)
                    {
                        courseRepository.BatchSetCourseRepository(tempList);
                        totalCount += tempList.Count;
                        Console.WriteLine(string.Format("第{0}次,导入完成{1}条.", pageCount, totalCount));
                        VTX.FW.Helper.LogHelper.WriteInfo("RunCourse", string.Format("第{0}次,导入完成{1}条.", pageCount, totalCount));
                        foreach (var item in tempList)
                        {
                            RunCourseStudent(cookie, item.CourseId);
                            RunCourseTeacher(cookie, item.CourseId);
                            RunCourseInfo(cookie, item.CourseId);
                        }
                    }
                    if (totalNum % perpage == 0)
                    {
                        pageCount = totalNum / perpage;
                    }
                    else
                    {
                        pageCount = totalNum / perpage + 1;
                    }
                    if (totalNum > perpage)
                    {
                        for (var i = 2; i <= pageCount; i++)
                        {
                            Thread.Sleep(1000 * 2);
                            Console.WriteLine(string.Format("第{0}/{1}次获取课程数据", i, pageCount));
                            VTX.FW.Helper.LogHelper.WriteInfo("RunCourse", string.Format("第{0}/{1}次获取课程数据", i, pageCount));
                            paramStr = string.Format(queryStr, i, perpage);
                            var sub_content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
                            var sub_response = await request.PostAsync(url, sub_content);
                            var sub_result = sub_response.Content.ReadAsStringAsync().Result;
                            if (!string.IsNullOrWhiteSpace(sub_result))
                            {
                                JObject sub_rootObj = JObject.Parse(sub_result);
                                if (!string.IsNullOrWhiteSpace(sub_rootObj.GetString("data")))
                                {
                                    JObject sub_dataObj = JObject.Parse(sub_rootObj.GetString("data"));
                                    var subtempList = ParseJson(sub_dataObj.GetString("courseList"));
                                    if (subtempList != null && subtempList.Count > 0)
                                    {
                                        courseRepository.BatchSetCourseRepository(subtempList);
                                        totalCount += subtempList.Count;
                                        Console.WriteLine(string.Format("第{0}次,导入完成{1}条.", i, totalCount));
                                        VTX.FW.Helper.LogHelper.WriteInfo("RunCourse", string.Format("第{0}次,导入完成{1}条.", i, totalCount));
                                        foreach (var sItem in subtempList)
                                        {
                                            RunCourseStudent(cookie, sItem.CourseId);
                                            RunCourseTeacher(cookie, sItem.CourseId);
                                            RunCourseInfo(cookie, sItem.CourseId);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

        }

        /// <summary>
        /// JSON字符串转课程列表
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<RB_Course> ParseJson(string data)
        {
            List<RB_Course> list = new();
            JArray courseArray = JArray.Parse(data);
            if (courseArray != null && courseArray.Count > 0)
            {
                foreach (var jItem in courseArray)
                {
                    JObject courseObj = JObject.Parse(jItem.ToString());
                    var expiryTime = ConvertHelper.UnixToDateTime(courseObj.GetInt("expiryTime"));
                    if (ConvertHelper.FormatTime(expiryTime) == "1970-01-01 08:00:00")
                    {
                        expiryTime = new DateTime(0001, 01, 01);
                    }
                    list.Add(new RB_Course()
                    {
                        CourseId = courseObj.GetInt("courseId"),
                        CourseName = courseObj.GetString("courseName"),
                        BeginTime = ConvertHelper.UnixToDateTime(courseObj.GetInt("beginTime")),
                        CompleteNum = courseObj.GetInt("completeNum"),
                        TotalClassNum = courseObj.GetInt("totalClassNum"),
                        ExpiryTime = expiryTime,
                        LiveNum = courseObj.GetInt("liveNum"),
                        RecordNum = courseObj.GetInt("recordNum"),
                        OpenNum = courseObj.GetInt("openNum"),
                        StudentNum = courseObj.GetInt("studentNum"),
                        AuditNum = courseObj.GetInt("auditNum"),
                        TeacherNum = courseObj.GetInt("teacherNum"),
                        CourseStatus = courseObj.GetInt("courseStatus"),
                        WebCast = courseObj.GetString("webCast"),
                        TeacherId = courseObj.GetInt("teacherId"),
                        TeacherAccount = courseObj.GetString("teacherAccount"),
                        TeacherUid = courseObj.GetInt("teacherUid"),
                        TeacherName = courseObj.GetString("teacherName"),
                        TeacherLogo = courseObj.GetString("teacherLogo"),
                        CourseType = courseObj.GetInt("courseType"),
                    }); ;
                }
            }
            return list;
        }

        /// <summary>
        /// 获取课程关联学员列表
        /// </summary>

        public static async void RunCourseStudent(string cookie, int courseId)
        {
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            string queryStr = "courseId={0}";
            string paramStr = string.Format(queryStr, courseId);
            var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
            ICourseStudentRepository courseStudentRepository = new CourseStudentRepository();

            Console.WriteLine(string.Format("开始获取{0}课程学员数据", courseId));
            VTX.FW.Helper.LogHelper.WriteInfo("RunCourseStudent", string.Format("开始获取{0}课程学员数据", courseId));
            string url = "https://console.eeo.cn/saasajax/student.ajax.php?action=getCourseStudentList";
            var response = await request.PostAsync(url, content);
            var sutResult = response.Content.ReadAsStringAsync().Result;
            List<RB_Course_Student> list = new();
            if (!string.IsNullOrWhiteSpace(sutResult))
            {
                JObject stuRootObj = JObject.Parse(sutResult);
                if (!string.IsNullOrWhiteSpace(stuRootObj.GetString("data")))
                {
                    JArray courseStudentArray = JArray.Parse(stuRootObj.GetString("data"));
                    if (courseStudentArray != null && courseStudentArray.Count > 0)
                    {
                        foreach (var jItem in courseStudentArray)
                        {
                            JObject courseStuObj = JObject.Parse(jItem.ToString());
                            list.Add(new RB_Course_Student()
                            {
                                id = courseStuObj.GetInt("id"),
                                uid = courseStuObj.GetInt("uid"),
                                name = courseStuObj.GetString("name"),
                                account = courseStuObj.GetString("account"),
                                logo = courseStuObj.GetString("logo"),
                                courseId = courseId
                            });
                        }
                    }
                }
            }
            if (list != null && list.Count > 0)
            {
                courseStudentRepository.BatchSetCourseStudentRepository(list);
            }
        }

        /// <summary>
        /// 获取课程关联老师列表
        /// </summary>
        /// <param name="cookie"></param>
        /// <param name="courseId"></param>
        public static async void RunCourseTeacher(string cookie, int courseId)
        {
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            string queryStr = "courseId={0}";
            string paramStr = string.Format(queryStr, courseId);
            var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
            ICourseTeacherRepository  courseTeacherRepository = new CourseTeacherRepository();

            Console.WriteLine(string.Format("开始获取{0}课程老师数据", courseId));
            VTX.FW.Helper.LogHelper.WriteInfo("RunCourseTeacher", string.Format("开始获取{0}课程老师数据", courseId));
            string url = "https://console.eeo.cn/saasajax/course.ajax.php?action=getCourseTeacherList";
            var response = await request.PostAsync(url, content);
            var teacherResult = response.Content.ReadAsStringAsync().Result;
            List<RB_Course_Teacher> list = new();
            if (!string.IsNullOrWhiteSpace(teacherResult))
            {
                JObject teacherRootObj = JObject.Parse(teacherResult);
                if (!string.IsNullOrWhiteSpace(teacherRootObj.GetString("data")))
                {
                    JObject teacherObj= JObject.Parse(teacherRootObj.GetString("data"));
                    if (!string.IsNullOrWhiteSpace(teacherObj.GetString("teacherList")))
                    {
                        JArray courseTeacherArray = JArray.Parse(teacherObj.GetString("teacherList"));
                        if (courseTeacherArray != null && courseTeacherArray.Count > 0)
                        {
                            foreach (var jItem in courseTeacherArray)
                            {
                                JObject courseTeacherObj = JObject.Parse(jItem.ToString());
                                JObject infoObj = JObject.Parse(courseTeacherObj.GetString("teacherInfo"));
                                list.Add(new RB_Course_Teacher()
                                {
                                    id = infoObj.GetInt("id"),
                                    uid = infoObj.GetInt("uid"),
                                    phone = infoObj.GetString("phone"),
                                    logo = infoObj.GetString("logo"),
                                    name = infoObj.GetString("name"),
                                    courseId = courseId,
                                    courseTeacherId= courseTeacherObj.GetInt("courseTeacherId")
                                });
                            }
                        }
                    }
                }
            }
            if (list != null && list.Count > 0)
            {
                courseTeacherRepository.BatchSetCourseTeacherRepository(list);
            }
        }

        /// <summary>
        /// 查询课程信息
        /// </summary>
        /// <param name="cookie"></param>
        /// <param name="courseId"></param>
        public static async void RunCourseInfo(string cookie, int courseId)
        {
            var request = Utility.HttpHelper.GenerateHttp(cookie);
            string queryStr = "courseId={0}";
            string paramStr = string.Format(queryStr, courseId);
            var content = new StringContent(paramStr, System.Text.Encoding.UTF8, "application/x-www-form-urlencoded");
            ICourseRepository  courseRepository = new CourseRepository();

            Console.WriteLine(string.Format("开始获取{0}课程详情数据", courseId));
            VTX.FW.Helper.LogHelper.WriteInfo("RunCourseInfo", string.Format("开始获取{0}课程详情数据", courseId));
            string url = "https://console.eeo.cn/saasajax/course.ajax.php?action=getCourseInfo";
            var response = await request.PostAsync(url, content);
            var courseInfoResult = response.Content.ReadAsStringAsync().Result;
            List<RB_Course> list = new();
            if (!string.IsNullOrWhiteSpace(courseInfoResult))
            {
                JObject courseRootObj = JObject.Parse(courseInfoResult);
                if (!string.IsNullOrWhiteSpace(courseRootObj.GetString("data")))
                {
                    JObject courseObj = JObject.Parse(courseRootObj.GetString("data"));
                    var expiryTime = ConvertHelper.UnixToDateTime(courseObj.GetInt("expiryTime"));
                    if (ConvertHelper.FormatTime(expiryTime) == "1970-01-01 08:00:00")
                    {
                        expiryTime = new DateTime(0001, 01, 01);
                    }
                    var courseModel = new RB_Course()
                    {
                        CourseId = courseObj.GetInt("courseId"),
                        CourseName = courseObj.GetString("courseName"),
                        BeginTime = ConvertHelper.UnixToDateTime(courseObj.GetInt("beginTime")),
                        CompleteNum = courseObj.GetInt("completeNum"),
                        TotalClassNum = courseObj.GetInt("totalClassNum"),
                        ExpiryTime = expiryTime,
                        LiveNum = courseObj.GetInt("liveNum"),
                        RecordNum = courseObj.GetInt("recordNum"),
                        OpenNum = courseObj.GetInt("openNum"),
                        StudentNum = courseObj.GetInt("studentNum"),
                        AuditNum = courseObj.GetInt("auditNum"),
                        TeacherNum = courseObj.GetInt("teacherNum"),
                        CourseStatus = courseObj.GetInt("courseStatus"),
                        WebCast = courseObj.GetString("webCast"),
                        TeacherId = courseObj.GetInt("teacherId"),
                        TeacherAccount = courseObj.GetString("teacherAccount"),
                        TeacherUid = courseObj.GetInt("teacherUid"),
                        TeacherName = courseObj.GetString("teacherName"),
                        TeacherLogo = courseObj.GetString("teacherLogo"),
                        CourseType = courseObj.GetInt("courseType"),
                        AddTime = ConvertHelper.UnixToDateTime(courseObj.GetInt("addTime")),
                        CourseWare = courseObj.GetString("courseWare"),
                    };
                    string tempCoverImg = courseObj.GetString("coverImg");
                    string coverImg = "";
                    if (!string.IsNullOrWhiteSpace(tempCoverImg))
                    {
                        coverImg = "https://console.eeo.cn/upload/images/" + tempCoverImg;
                    }
                    courseModel.CoverImg = coverImg;
                    list.Add(courseModel);
                }
            }
            if (list != null && list.Count > 0)
            {
                courseRepository.BatchSetCourseOtherRepository(list);
            }
        }
    }
}
