﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.Attr;

namespace EduSpider.Model.Entity
{
    /// <summary>
    /// 课程评价配置详情实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Course_CommentDetails
    {
        /// <summary>
        /// 课程评价详情主键编号
        /// </summary>
        public int DetailId { get; set; }

        /// <summary>
        /// 课程评价主表编号
        /// </summary>
        public int CourseCommentId { get; set; }

        /// <summary>
        /// 开始值
        /// </summary>
        public decimal StartNum { get; set; }

        /// <summary>
        /// 结束值
        /// </summary>
        public decimal EndNum { get; set; }

        /// <summary>
        /// 评价内容
        /// </summary>
        public string Info { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateTime { get; set; }

        /// <summary>
        /// 修改人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateTime { get; set; }
    }
}
