﻿
using EduSpider.IRepository;
using EduSpider.IServices;
using EduSpider.Model.Cache;
using EduSpider.Model.Extend;
using EduSpider.Repository;
using EduSpider.Utility.Data;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VTX.FW.Attr;
using VTX.FW.DB;
using VTX.FW.Helper;

namespace EduSpider.Services
{
    /// <summary>
    /// 考试服务实现
    /// </summary>
    public class ExamService : IExamService
    {
        /// <summary>
        /// 帐号仓储接口
        /// </summary>
        [Autowired]
        private IAccountRepository AccountRepository { get; set; }
        /// <summary>
        /// 考试
        /// </summary>
        [Autowired]
        private IExamRepository ExamRepository { get; set; }
        /// <summary>
        /// 考试题目
        /// </summary>
        [Autowired]
        private IExam_QuestionsRepository Exam_QuestionsRepository { get; set; }
        /// <summary>
        /// 考试得分
        /// </summary>
        [Autowired]
        private IExam_ScoreRepository Exam_ScoreRepository { get; set; }
        /// <summary>
        /// 学生
        /// </summary>
        [Autowired]
        private IStudentRepository StudentRepository { get; set; }

        /// <summary>
        /// 获取考试分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Exam_Extend> GetExamPageList(int pageIndex, int pageSize, out long count, RB_Exam_Extend demodel)
        {
            return ExamRepository.GetExamPageList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 获取考试学生列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Exam_Score_Extend> GetExamStuList(RB_Exam_Score_Extend demodel)
        {
            return Exam_ScoreRepository.GetList(demodel);
        }

        /// <summary>
        /// 获取学生考试详情
        /// </summary>
        /// <param name="examId"></param>
        /// <param name="stuId"></param>
        /// <param name="stuUId"></param>
        /// <returns></returns>
        public object GetExamStuScoreInfo(int examId, int stuId, int stuUId, out string msg)
        {
            msg = "";
            if (stuUId > 0) {
                var accountModel = AccountRepository.GetAccountList(new rb_account_hk_Extend() { AccountId = stuUId, AccountType = Utility.Enum.AccountTypeEnum.Student }).FirstOrDefault();
                if (accountModel == null) { msg = "账号不存在"; return ""; }
                stuId = accountModel.Id;
            }
            var stuModel = StudentRepository.GetEntity(stuId);
            if (stuModel == null) { msg = "学生信息不存在"; return ""; }
            var examModel = ExamRepository.GetEntity(examId);
            if (examModel == null) { msg = "考试信息不存在"; return ""; }
            if (examModel.Type == 3) { msg = "统计分析无法请求"; return ""; }
            //考试题目
            var qlist = Exam_QuestionsRepository.GetList(new RB_Exam_Questions_Extend() { ExamId = examId });
            //考试成绩
            var sExamModel = Exam_ScoreRepository.GetList(new RB_Exam_Score_Extend() { ExamId = examId, StuId = stuId }).FirstOrDefault();
            if (sExamModel != null) {
                sExamModel.ScoreList = JsonHelper.Deserialize<List<ExamQScoreModel>>(sExamModel.Content);
                foreach (var qitem in sExamModel.ScoreList) {
                    var qmodel = qlist.Where(x => x.Sort == qitem.Sort).FirstOrDefault();
                    qitem.Difficulty = qmodel?.Difficulty ?? "";
                    qitem.KnowledgePoint = qmodel?.KnowledgePoint ?? "";
                    qitem.QScore = qmodel?.Score ?? 0;
                    qitem.GroupName = qmodel?.GroupName ?? "";
                }
            }

            //组装一试  二试 排名
            if (examModel.Type == 2)
            {
                var sExamList = Exam_ScoreRepository.GetList(new RB_Exam_Score_Extend() { ExamId = examId }).ToList();//当前考试的所有信息
                foreach (var item in sExamList) {
                    item.ScoreList = JsonHelper.Deserialize<List<ExamQScoreModel>>(item.Content);
                    foreach (var qitem in item.ScoreList)
                    {
                        var qmodel = qlist.Where(x => x.Sort == qitem.Sort).FirstOrDefault();
                        qitem.Difficulty = qmodel?.Difficulty ?? "";
                        qitem.KnowledgePoint = qmodel?.KnowledgePoint ?? "";
                        qitem.QScore = qmodel?.Score ?? 0;
                        qitem.GroupName = qmodel?.GroupName ?? "";
                    }
                }

                var groupList = sExamModel.ScoreList.Select(x => x.GroupName).ToList();
                foreach (var groupName in groupList)
                {
                    foreach (var qitem in sExamList) {
                        //计算一试得分
                        qitem.AScore = qitem.ScoreList.Where(x => x.GroupName == groupName).Sum(x => x.Score);
                    }
                    //看分组排名
                    int Rank = 1;
                    sExamList.OrderByDescending(x => x.AScore).GroupBy(x => x.AScore).ToList().ForEach(x =>
                    {
                        x.ToList().ForEach(y =>
                        {
                            y.ARank = Rank;
                        });
                        Rank += x.Count();
                    });

                    sExamModel?.ScoreList.Where(x => x.GroupName == groupName).ToList().ForEach(x =>
                    {
                        x.AScore = sExamList.Where(x => x.StuId == stuId).FirstOrDefault()?.AScore ?? 0;
                        x.ARank = sExamList.Where(x => x.StuId == stuId).FirstOrDefault()?.ARank ?? 0;
                    });

                }
            }

            //开始组装数据
            return new
            {
                StuId = stuModel.StudId,
                StuName = stuModel.StudentName,
                examModel.ExamName,
                examModel.Type,
                sExamModel?.TScore,
                sExamModel?.Rank,
                sExamModel?.RankRate,
                ScoreRate = Math.Round((sExamModel?.TScore ?? 0) / (sExamModel?.ExamScore ?? 1), 2, MidpointRounding.AwayFromZero),
                ScoreList = sExamModel?.ScoreList.Select(x => new
                {
                    x.GroupName,
                    x.Sort,
                    x.Difficulty,
                    x.KnowledgePoint,
                    x.QScore,
                    x.Score,
                    ScoreRate = Math.Round(x.Score / x.QScore, 2, MidpointRounding.AwayFromZero),
                    AvgScore = Math.Round(x.AvgScore, 6, MidpointRounding.AwayFromZero),
                    AvgScoreRate = Math.Round(x.AvgScore / x.QScore, 2, MidpointRounding.AwayFromZero),
                }),
                ModuleList = sExamModel?.ScoreList.GroupBy(x => new { x.KnowledgePoint }).Select(x => new
                {
                    Module = x.Key.KnowledgePoint.Length > 6 ? x.Key.KnowledgePoint.Substring(0, 6) + ".." : x.Key.KnowledgePoint,
                    Score = x.Sum(y => y.QScore),
                    ScoreRate = Math.Round(x.Sum(y => y.Score) / x.Sum(y => y.QScore), 2, MidpointRounding.AwayFromZero),
                    AvgScoreRate = Math.Round(x.Sum(y => y.AvgScore) / x.Sum(y => y.QScore), 2, MidpointRounding.AwayFromZero),
                    PScore = x.Sum(y => y.Score),
                    AvgScore = x.Sum(y => y.AvgScore)
                }),
                GroupModuleList = examModel.Type == 2 ? sExamModel?.ScoreList.GroupBy(z => new { z.GroupName }).Select(z => new
                {
                    GroupName = z.Key,
                    TScore = z.FirstOrDefault().AScore,//总分
                    Rank = z.FirstOrDefault().ARank,//排名
                    GroupList = z.GroupBy(x => new { x.KnowledgePoint }).Select(x => new
                    {
                        Module = x.Key.KnowledgePoint.Length > 6 ? x.Key.KnowledgePoint.Substring(0, 6) + ".." : x.Key.KnowledgePoint,
                        Score = x.Sum(y => y.QScore),
                        ScoreRate = Math.Round(x.Sum(y => y.Score) / x.Sum(y => y.QScore), 2, MidpointRounding.AwayFromZero),
                        AvgScoreRate = Math.Round(x.Sum(y => y.AvgScore) / x.Sum(y => y.QScore), 2, MidpointRounding.AwayFromZero),
                        PScore = x.Sum(y => y.Score),
                        AvgScore = x.Sum(y => y.AvgScore)
                    })
                }) : null,
                DifficultyList = sExamModel?.ScoreList.GroupBy(x => new { x.Difficulty }).Select(x => new
                {
                    Difficulty = x.Key.Difficulty == "易" ? "简单题" : x.Key.Difficulty == "中" ? "中档题" : "难题",
                    Count = x.Count(),
                    Score = x.Sum(x => x.QScore)
                }),
                DifficultyRateList = sExamModel?.ScoreList.GroupBy(x => new { x.Difficulty }).Select(x => new
                {
                    Difficulty = x.Key.Difficulty == "易" ? "简单题" : x.Key.Difficulty == "中" ? "中档题" : "难题",
                    ScoreRate = Math.Round(x.Sum(y => y.Score) / x.Sum(y => y.QScore), 2, MidpointRounding.AwayFromZero),
                    AvgScoreRate = Math.Round(x.Sum(y => y.AvgScore) / x.Sum(y => y.QScore), 2, MidpointRounding.AwayFromZero),
                })
            };
        }

        /// <summary>
        /// 获取学生考试详情（分组）
        /// </summary>
        /// <param name="examId"></param>
        /// <param name="stuId"></param>
        /// <param name="stuUId"></param>
        /// <returns></returns>
        public object GetExamStuScoreInfo_Group(int examId, int stuId, int stuUId)
        {
            if (stuUId > 0)
            {
                var accountModel = AccountRepository.GetAccountList(new rb_account_hk_Extend() { AccountId = stuUId, AccountType = Utility.Enum.AccountTypeEnum.Student }).FirstOrDefault();
                if (accountModel == null) { return ""; }
                stuId = accountModel.Id;
            }
            var stuModel = StudentRepository.GetEntity(stuId);
            if (stuModel == null) { return ""; }
            var examModel = ExamRepository.GetEntity(examId);
            if (examModel == null) { return ""; }
            //考试题目
            var qlist = Exam_QuestionsRepository.GetList(new RB_Exam_Questions_Extend() { ExamId = examId });
            //考试成绩
            var sExamModel = Exam_ScoreRepository.GetList(new RB_Exam_Score_Extend() { ExamId = examId, StuId = stuId }).FirstOrDefault();
            if (sExamModel != null)
            {
                sExamModel.ScoreList = JsonHelper.Deserialize<List<ExamQScoreModel>>(sExamModel.Content);
                foreach (var qitem in sExamModel.ScoreList)
                {
                    qitem.Difficulty = qlist.Where(x => x.Sort == qitem.Sort).FirstOrDefault()?.Difficulty ?? "";
                    qitem.KnowledgePoint = qlist.Where(x => x.Sort == qitem.Sort).FirstOrDefault()?.KnowledgePoint ?? "";
                    qitem.QScore = qlist.Where(x => x.Sort == qitem.Sort).FirstOrDefault()?.Score ?? 0;
                    qitem.GroupName = qlist.Where(x => x.Sort == qitem.Sort).FirstOrDefault()?.GroupName ?? "";
                }
            }


            //开始组装数据
            return new
            {
                StuId = stuModel.StudId,
                StuName = stuModel.StudentName,
                examModel.ExamName,
                sExamModel?.TScore,
                sExamModel?.Rank,
                sExamModel?.RankRate,
                ScoreRate = Math.Round((sExamModel?.TScore ?? 0) / (sExamModel?.ExamScore ?? 1), 2, MidpointRounding.AwayFromZero),
                //ScoreList = sExamModel?.ScoreList.GroupBy(x => new { x.GroupName }).Select(x => new
                //{
                //    GroupName = x.Key,
                //    GroupList = x.Select(z => new
                //    {
                //        z.Sort,
                //        z.Difficulty,
                //        z.KnowledgePoint,
                //        z.QScore,
                //        z.Score,
                //        ScoreRate = Math.Round(z.Score / z.QScore, 2, MidpointRounding.AwayFromZero),
                //        AvgScore = Math.Round(z.AvgScore, 6, MidpointRounding.AwayFromZero),
                //        AvgScoreRate = Math.Round(z.AvgScore / z.QScore, 2, MidpointRounding.AwayFromZero)
                //    })
                //}),
                ScoreList = sExamModel?.ScoreList.Select(z => new
                {
                    z.GroupName,
                    z.Sort,
                    z.Difficulty,
                    z.KnowledgePoint,
                    z.QScore,
                    z.Score,
                    ScoreRate = Math.Round(z.Score / z.QScore, 2, MidpointRounding.AwayFromZero),
                    AvgScore = Math.Round(z.AvgScore, 6, MidpointRounding.AwayFromZero),
                    AvgScoreRate = Math.Round(z.AvgScore / z.QScore, 2, MidpointRounding.AwayFromZero)
                }),
                //ModuleList = sExamModel?.ScoreList.GroupBy(x => new { x.KnowledgePoint }).Take(8).Select(x => new
                //{
                //    Module = x.Key.KnowledgePoint.Length > 6 ? x.Key.KnowledgePoint.Substring(0, 6) + ".." : x.Key.KnowledgePoint,
                //    Score = x.Sum(y => y.QScore),
                //    ScoreRate = Math.Round(x.Sum(y => y.Score) / x.Sum(y => y.QScore), 2, MidpointRounding.AwayFromZero),
                //    AvgScoreRate = Math.Round(x.Sum(y => y.AvgScore) / x.Sum(y => y.QScore), 2, MidpointRounding.AwayFromZero),
                //}),
                ModuleList = sExamModel?.ScoreList.GroupBy(z => new { z.GroupName }).Select(z => new
                {
                    GroupName = z.Key,
                    GroupList = z.GroupBy(x => new { x.KnowledgePoint }).Take(8).Select(x => new
                    {
                        Module = x.Key.KnowledgePoint.Length > 6 ? x.Key.KnowledgePoint.Substring(0, 6) + ".." : x.Key.KnowledgePoint,
                        Score = x.Sum(y => y.QScore),
                        ScoreRate = Math.Round(x.Sum(y => y.Score) / x.Sum(y => y.QScore), 2, MidpointRounding.AwayFromZero),
                        AvgScoreRate = Math.Round(x.Sum(y => y.AvgScore) / x.Sum(y => y.QScore), 2, MidpointRounding.AwayFromZero),
                    })

                }),
                DifficultyList = sExamModel?.ScoreList.GroupBy(x => new { x.Difficulty }).Select(x => new
                {
                    Difficulty = x.Key.Difficulty == "易" ? "简单题" : x.Key.Difficulty == "中" ? "中档题" : "难题",
                    Count = x.Count(),
                    Score = x.Sum(x => x.QScore)
                }),
                DifficultyRateList = sExamModel?.ScoreList.GroupBy(x => new { x.Difficulty }).Select(x => new
                {
                    Difficulty = x.Key.Difficulty == "易" ? "简单题" : x.Key.Difficulty == "中" ? "中档题" : "难题",
                    ScoreRate = Math.Round(x.Sum(y => y.Score) / x.Sum(y => y.QScore), 2, MidpointRounding.AwayFromZero),
                    AvgScoreRate = Math.Round(x.Sum(y => y.AvgScore) / x.Sum(y => y.QScore), 2, MidpointRounding.AwayFromZero),
                })
            };
        }

        /// <summary>
        /// 删除考试
        /// </summary>
        /// <param name="examId"></param>
        /// <param name="baseUserId"></param>
        /// <returns></returns>
        public string DelExamInfo(int examId, int baseUserId)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Exam_Extend.Status), 1},
                { nameof(RB_Exam_Extend.UpdateBy), baseUserId},
                { nameof(RB_Exam_Extend.UpdateTime), DateTime.Now},
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName = nameof(RB_Exam_Extend.ExamId),
                      FiledValue = examId,
                       OperatorEnum =OperatorEnum.Equal
                }
            };
            bool flag = ExamRepository.Update(keyValues, wheres);
            return flag ? "" : "出错了，请联系管理员";
        }

        /// <summary>
        /// 导入考试成绩
        /// </summary>
        /// <param name="path_server"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public string ImportExcelForStuExamScore(string path_server,int courseId, string examName, int userId)
        {
            var umodel = AccountRepository.GetAccountList(new Model.Extend.rb_account_hk_Extend() { Id = userId, AccountType =  Utility.Enum.AccountTypeEnum.Teacher }).FirstOrDefault();
            if (umodel == null || umodel.Status == Utility.Enum.DateStateEnum.Delete || umodel.AccountType != Utility.Enum.AccountTypeEnum.Teacher) { return "没有权限操作"; }
            var EQlist = StuExamScoreHelper.GetStuExamScoreData(path_server, out List<StuScoreModel> StuList, out string msg, out int type);
            if (msg != "") { return msg; }
            if (EQlist.Any())
            {
                var AvgList = StuList.Where(x => x.Name == "平均分").ToList();
                StuList = StuList.Where(x => x.Name != "平均分" && !string.IsNullOrWhiteSpace(x.Name)).ToList();
                //根据学生姓名 查询所有的学生账号
                string StuNames = "'" + string.Join("','", StuList.Select(x => x.Name).Distinct()) + "'";
                var sList = StudentRepository.GetListForStuName(StuNames, courseId);

                //插入考试
                int ExamId = ExamRepository.Insert(new Model.Entity.RB_Exam()
                {
                    ExamId = 0,
                    CourseId = courseId,
                    ExamName = examName,
                    CreateBy = userId,
                    CreateTime = DateTime.Now,
                    Status = 0,
                    Type = type
                });
                if (ExamId > 0) {
                    List<Model.Entity.RB_Exam_Questions> InsertEQ = new();
                    //开始插入题目
                    foreach (var item in EQlist)
                    {
                        InsertEQ.Add(new Model.Entity.RB_Exam_Questions()
                        {
                            Id = 0,
                            ExamId = ExamId,
                            Difficulty = item.Difficulty,
                            KnowledgePoint = item.KnowledgePoint,
                            Score = item.Score,
                            Sort = item.Id,
                            GroupName = item.GroupName
                        });
                    }
                    Exam_QuestionsRepository.BatchInsert(InsertEQ);

                    decimal ExamScore = InsertEQ.Sum(x => x.Score);
                    List<Model.Entity.RB_Exam_Score> InsertScore = new();
                    foreach (var Name in StuList.Select(x => x.Name).Distinct()) {
                        var clist = StuList.Where(x => x.Name == Name).ToList();
                        var stuModel = sList.Where(x => x.StudentName == Name).FirstOrDefault();
                        InsertScore.Add(new Model.Entity.RB_Exam_Score()
                        {
                            Id = 0,
                            ExamId = ExamId,
                            StuId = stuModel?.StudId ?? 0,//匹配学生失败  可能要在后台给与提示， 重新导入
                            StuUId = stuModel?.StudentUid ?? 0,
                            StuName = Name,
                            Content = JsonHelper.Serialize(clist.Where(x => x.Id > 0).Select(x => new
                            {
                                Sort = x.Id,
                                x.Score,
                                AvgScore = Math.Round(AvgList.Where(y => y.Id == x.Id).FirstOrDefault()?.Score ?? 0, 6, MidpointRounding.AwayFromZero)
                            })),
                            TScore = clist.Where(x => x.Id == -1).FirstOrDefault()?.Score ?? 0,
                            Rank = Convert.ToInt32(clist.Where(x => x.Id == -2).FirstOrDefault()?.Score ?? 0),
                            RankRate = clist.Where(x => x.Id == -3).FirstOrDefault()?.Score ?? 0,
                            ExamScore = ExamScore
                        });
                    }
                    //InsertScore = InsertScore.Where(x => x.StuId > 0).ToList();//暂时只插入匹配到学生的
                    Exam_ScoreRepository.BatchInsert(InsertScore);
                }

                return "";
            }
            else
            {
                return "模板匹配失败";
            }
        }

        /// <summary>
        /// 取消备份
        /// </summary>
        /// <param name="path_server"></param>
        /// <param name="courseId"></param>
        /// <param name="examName"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public string ImportExcelForStuExamScore_V2(string path_server, int courseId, string examName, int userId)
        {
            var umodel = AccountRepository.GetAccountList(new Model.Extend.rb_account_hk_Extend() { Id = userId }).FirstOrDefault();
            if (umodel == null || umodel.Status == Utility.Enum.DateStateEnum.Delete || umodel.AccountType != Utility.Enum.AccountTypeEnum.Teacher) { return "没有权限操作"; }
            var EQlist = StuExamScoreHelper.GetStuExamScoreData(path_server, out List<StuScoreModel> StuList, out string msg, out int type);
            if (msg != "") { return msg; }
            if (EQlist.Any())
            {
                var AvgList = StuList.Where(x => x.Name == "平均分").ToList();
                StuList = StuList.Where(x => x.Name != "平均分" && !string.IsNullOrWhiteSpace(x.Name)).ToList();
                //根据学生姓名 查询所有的学生账号
                string StuNames = "'" + string.Join("','", StuList.Select(x => x.Name).Distinct()) + "'";
                var sList = StudentRepository.GetListForStuName(StuNames, courseId);

                //插入考试
                int ExamId = ExamRepository.Insert(new Model.Entity.RB_Exam()
                {
                    ExamId = 0,
                    CourseId = courseId,
                    ExamName = examName,
                    CreateBy = userId,
                    CreateTime = DateTime.Now,
                    Status = 0
                });
                if (ExamId > 0)
                {
                    List<Model.Entity.RB_Exam_Questions> InsertEQ = new();
                    //开始插入题目
                    foreach (var item in EQlist)
                    {
                        InsertEQ.Add(new Model.Entity.RB_Exam_Questions()
                        {
                            Id = 0,
                            ExamId = ExamId,
                            Difficulty = item.Difficulty,
                            KnowledgePoint = item.KnowledgePoint,
                            Score = item.Score,
                            Sort = item.Id
                        });
                    }
                    Exam_QuestionsRepository.BatchInsert(InsertEQ);

                    List<Model.Entity.RB_Exam_Score> InsertScore = new();
                    //开始插入得分
                    foreach (var item in StuList)
                    {
                        var stuModel = sList.Where(x => x.StudentName == item.Name).FirstOrDefault();
                        InsertScore.Add(new Model.Entity.RB_Exam_Score()
                        {
                            Id = 0,
                            ExamId = ExamId,
                            //Sort = item.Id,
                            StuId = stuModel?.StudId ?? 0,//=0表示未匹配上 暂时=0处理
                            //Score = item.Score,
                            StuName = item.Name
                        });
                    }
                    Exam_ScoreRepository.BatchInsert(InsertScore);
                }

                return "";
            }
            else
            {
                return "模板匹配失败";
            }
        }

        /// <summary>
        /// 创建统计分析
        /// </summary>
        /// <param name="courseId"></param>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        public string SetExamStatAnalysis(int courseId, UserInfo userInfo)
        {
            //获取所有分组考试
            var examList = ExamRepository.GetExamList(new RB_Exam_Extend() { CourseId = courseId, Type = 2 }).OrderBy(x => x.ExamId).ToList();
            if (!examList.Any()) { return "未查询到分组考试信息，无法生成统计分析"; }
            //查询所有的 考试题
            string examIds = string.Join(",", examList.Select(x => x.ExamId));
            var questList = Exam_QuestionsRepository.GetList(new RB_Exam_Questions_Extend() { ExamIds = examIds });
            //查询所有的 学生分数
            var scoreList = Exam_ScoreRepository.GetList(new RB_Exam_Score_Extend() { ExamIds = examIds });
            scoreList = scoreList.Where(x => x.StuId > 0).ToList();
            examList = examList.Where(y => scoreList.Select(x => x.ExamId).Contains(y.ExamId)).ToList();
            foreach (var item in scoreList) {
                item.ScoreList = JsonHelper.Deserialize<List<ExamQScoreModel>>(item.Content);
                foreach (var qitem in item.ScoreList)
                {
                    var qmodel = questList.Where(x => x.ExamId == item.ExamId && x.Sort == qitem.Sort).FirstOrDefault();
                    qitem.Difficulty = qmodel?.Difficulty ?? "";
                    qitem.KnowledgePoint = qmodel?.KnowledgePoint ?? "";
                    qitem.QScore = qmodel?.Score ?? 0;
                    qitem.GroupName = qmodel?.GroupName ?? "";
                }

                item.PartScore = item.ScoreList.Where(x => x.Sort <= 8).Sum(x => x.Score);//个人1-8题得分
            }

            if (!scoreList.Any()) { return "未查询到学生考试成绩"; }

            int ExamId = ExamRepository.Insert(new Model.Entity.RB_Exam()
            {
                Type = 3,
                CourseId = courseId,
                CreateBy = userInfo.Id,
                CreateTime = DateTime.Now,
                ExamId = 0,
                ExamName = "统计分析",
                Status = 0,
                UpdateBy = userInfo.Id,
                UpdateTime = DateTime.Now
            });
            if (ExamId > 0) {

                try
                {
                    List<int> StuIdList = scoreList.Select(x => x.StuId).Distinct().ToList();
                    int stuNum = StuIdList.Count();

                    #region 1-8题统计
                    List<ExamPartScoreModel> StuPScoreList = new List<ExamPartScoreModel>();// 1-8题得分列表
                    List<ExamPartScoreModel> TestScoreList = new List<ExamPartScoreModel>();//一试二试排名列表
                    List<ExamPartScoreModel> TRScoreList = new List<ExamPartScoreModel>();//总排名列表


                    //1-8题统计  先看1-8题 平均得分   x轴 考试次数, y轴 得分
                    int ExamNum = 1, MaxGroupNum = 1;
                    foreach (var item in examList) {
                        //先算平均得分
                        var esList = scoreList.Where(x => x.ExamId == item.ExamId).ToList();
                        decimal avgScore = Math.Round(esList.Sum(x => x.PartScore) / esList.Count(), 2, MidpointRounding.AwayFromZero);//1-8题  平均得分

                        //查看所有的分组
                        var groupList = questList.Where(x => x.ExamId == item.ExamId).Select(x => x.GroupName).Distinct();
                        int groupNum = 1;
                        foreach (var groupName in groupList)
                        {
                            //组装一试排名  二试排名
                            foreach (var qitem in esList)
                            {
                                qitem.AScore = qitem.ScoreList.Where(x => x.GroupName == groupName).Sum(x => x.Score);
                                qitem.ScoreList.Where(x => x.GroupName == groupName).ToList().ForEach(x =>
                                {
                                    x.GroupNum = groupNum;                                
                                });
                            }
                            int Rank = 1;
                            esList.OrderByDescending(x => x.AScore).GroupBy(x => x.AScore).ToList().ForEach(x =>
                              {
                                  x.ToList().ForEach(y =>
                                  {
                                      y.ARank = Rank;
                                  });
                                  Rank += x.Count();
                              });

                            foreach (var stuId in StuIdList)
                            {
                                //插入分组排名
                                TestScoreList.Add(new ExamPartScoreModel()
                                {
                                    StuId = stuId,
                                    Sort = ExamNum,
                                    ExamName = item.ExamName,
                                    GroupName = groupName,
                                    Score = esList.Where(x => x.StuId == stuId).FirstOrDefault()?.ARank ?? 0,
                                    TScore = esList.Where(x => x.StuId == stuId).FirstOrDefault()?.AScore ?? 0,
                                    GroupNum = groupNum
                                });
                            }
                            if (MaxGroupNum < groupNum) { MaxGroupNum = groupNum; }

                            questList.Where(x => x.ExamId == item.ExamId && x.GroupName == groupName).ToList().ForEach(x => x.GroupNum = groupNum);
                            groupNum++;
                        }


                        //开始插入  遍历所有的 学生
                        foreach (var stuId in StuIdList) {
                            //插入1-8题
                            StuPScoreList.Add(new ExamPartScoreModel()
                            {
                                StuId = stuId,
                                Sort = ExamNum,
                                AvgScore = avgScore,
                                ExamName = item.ExamName,
                                Score = esList.Where(x => x.StuId == stuId).FirstOrDefault()?.PartScore ?? 0
                            });
                            //插入总排名
                            TRScoreList.Add(new ExamPartScoreModel()
                            {
                                StuId = stuId,
                                Sort = ExamNum,
                                ExamName = item.ExamName,
                                Score = esList.Where(x => x.StuId == stuId).FirstOrDefault()?.Rank ?? 0,
                                TScore = esList.Where(x => x.StuId == stuId).FirstOrDefault()?.TScore ?? 0,
                            });
                        }
                        ExamNum++;
                    }
                    #endregion

                    #region 模块分析
                    //分组版块分析表     x轴  知识点 ， y轴  分数（总分  个人分  平均分）  如果有多次考试  知识点 重复的  就累计使用
                    List<ExamPartScoreModel> ModuleScoreList = new List<ExamPartScoreModel>();//考试版块分析列表
                    var knowList = questList.Select(x => x.KnowledgePoint).Distinct();
                    foreach (var item in knowList) {

                        //查询分组
                        for (int groupN = 1; groupN <= MaxGroupNum; groupN++) {
                            decimal TotalScore = questList.Where(x => x.KnowledgePoint == item && x.GroupNum == groupN).Sum(x => x.Score);//知识点总分
                            if (TotalScore > 0)
                            {
                                decimal AvgScore = Math.Round(scoreList.Sum(x => x.ScoreList.Where(y => y.KnowledgePoint == item && y.GroupNum == groupN).Sum(y => y.Score)) / stuNum, 2, MidpointRounding.AwayFromZero);//知识点平均得分
                                foreach (var stuId in StuIdList)
                                {
                                    decimal Score = scoreList.Where(x => x.StuId == stuId).Sum(x => x.ScoreList.Where(y => y.KnowledgePoint == item && y.GroupNum == groupN).Sum(y => y.Score));//学生这些知识点的总得分
                                    ModuleScoreList.Add(new ExamPartScoreModel()
                                    {
                                        StuId = stuId,
                                        GroupNum = groupN,
                                        ExamName = item,
                                        Score = Score,
                                        TScore = TotalScore,
                                        AvgScore = AvgScore
                                    });
                                }
                            }
                        }
                    }
                    #endregion

                    #region 开始插入数据
                    int eNum = examList.Count();//考试数量
                    List<RB_Exam_Score_Extend> TRankList = new List<RB_Exam_Score_Extend>();//统计排名
                    foreach (var stuId in StuIdList) {
                        decimal TScore = Math.Round(scoreList.Where(x => x.StuId == stuId).Sum(x => x.TScore) / eNum, 2, MidpointRounding.AwayFromZero);// 平均几次考试 得到总分
                        decimal ExamScore = Math.Round(scoreList.Where(x => x.StuId == stuId).Sum(x => x.ExamScore) / eNum, 2, MidpointRounding.AwayFromZero);

                        TRankList.Add(new RB_Exam_Score_Extend()
                        {
                            StuId = stuId,
                            TScore = TScore,
                            ExamScore = ExamScore
                        });
                    }
                    int TRank = 1;
                    TRankList.OrderByDescending(x => x.TScore).GroupBy(x => x.TScore).ToList().ForEach(x =>
                    {
                        x.ToList().ForEach(y =>
                        {
                            y.Rank = TRank;
                            y.RankRate = Math.Round(Convert.ToDecimal(stuNum - TRank + 1) / stuNum, 2, MidpointRounding.AwayFromZero);
                        });
                        TRank += x.Count();
                    });

                    //插入
                    foreach (var stuId in StuIdList) {

                        ExamStatModel statModel = new ExamStatModel()
                        {
                            PartScoreList = StuPScoreList.Where(x => x.StuId == stuId).ToList(),
                            GroupScoreList = TestScoreList.Where(x => x.StuId == stuId).ToList(),
                            TRankScoreList = TRScoreList.Where(x => x.StuId == stuId).ToList(),
                            ModuleScoreList = ModuleScoreList.Where(x => x.StuId == stuId).ToList()
                        };
                        var smodel = scoreList.Where(x => x.StuId == stuId).FirstOrDefault();

                        var rmodel = TRankList.Where(x => x.StuId == stuId).FirstOrDefault();

                        Exam_ScoreRepository.Insert(new Model.Entity.RB_Exam_Score()
                        {
                            Id = 0,
                            StuId = stuId,
                            ExamId = ExamId,
                            StuUId = smodel.StuUId,
                            StuName = smodel.StuName,
                            Content = JsonHelper.Serialize(new
                            {
                                PartScoreList = statModel.PartScoreList.Select(x => new
                                {
                                    x.Sort,
                                    x.ExamName,
                                    x.AvgScore,
                                    x.Score
                                }),
                                ModuleScoreList = statModel.ModuleScoreList.Select(y => new
                                {
                                    y.GroupNum,
                                    y.ExamName,
                                    y.Score,
                                    y.AvgScore,
                                    y.TScore
                                }),
                                GroupScoreList = statModel.GroupScoreList.Select(y => new
                                {
                                    y.GroupNum,
                                    y.Sort,
                                    y.ExamName,
                                    y.Score,
                                    y.TScore
                                }),
                                TRankScoreList = statModel.TRankScoreList.Select(x => new
                                {
                                    x.Sort,
                                    x.ExamName,
                                    x.Score,
                                    x.TScore
                                })
                            }),
                            TScore = rmodel.TScore,
                            ExamScore = rmodel.ExamScore,
                            Rank = rmodel.Rank,
                            RankRate = rmodel.RankRate
                        });
                    }
                        #endregion
                }
                catch (Exception ex)
                {
                    LogHelper.WriteError("SetExamStatAnalysis", "", ex);
                    return "出错了，请联系管理员";
                }
            }

            return ExamId > 0 ? "" : "出错了，请联系管理员";
        }

        /// <summary>
        /// 获取统计分析详情
        /// </summary>
        /// <param name="examId"></param>
        /// <param name="stuId"></param>
        /// <param name="stuUId"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public object GetExamStatAnalysisInfo(int examId, int stuId, int stuUId, out string msg)
        {
            msg = "";
            if (stuUId > 0)
            {
                var accountModel = AccountRepository.GetAccountList(new rb_account_hk_Extend() { AccountId = stuUId, AccountType = Utility.Enum.AccountTypeEnum.Student }).FirstOrDefault();
                if (accountModel == null) { msg = "账号不存在"; return ""; }
                stuId = accountModel.Id;
            }
            var stuModel = StudentRepository.GetEntity(stuId);
            if (stuModel == null) { msg = "学生信息不存在"; return ""; }
            var examModel = ExamRepository.GetEntity(examId);
            if (examModel == null) { msg = "考试信息不存在"; return ""; }
            if (examModel.Type != 3) { msg = "非统计分析请求"; return ""; }
            //考试成绩
            var sExamModel = Exam_ScoreRepository.GetList(new RB_Exam_Score_Extend() { ExamId = examId, StuId = stuId }).FirstOrDefault();
            ExamStatModel statList = new ExamStatModel();
            if (sExamModel != null)
            {
                statList = JsonHelper.Deserialize<ExamStatModel>(sExamModel.Content);
            }

            //开始组装数据
            return new
            {
                StuId = stuModel.StudId,
                StuName = stuModel.StudentName,
                examModel.ExamName,
                sExamModel?.TScore,
                sExamModel?.Rank,
                sExamModel?.RankRate,
                ScoreRate = Math.Round((sExamModel?.TScore ?? 0) / (sExamModel?.ExamScore ?? 1), 2, MidpointRounding.AwayFromZero),
                PartScoreList = statList.PartScoreList.Select(x => new
                {
                    ExamNum = x.Sort,
                    x.ExamName,
                    x.AvgScore,
                    x.Score
                }),
                ModuleScoreList = statList.ModuleScoreList.GroupBy(x => x.GroupNum).Select(x => new
                {
                    GroupNum = x.Key,
                    GroupList = x.Select(y => new
                    {
                        KnowledgePoint = y.ExamName,
                        y.Score,
                        y.AvgScore,
                        y.TScore
                    })
                }),
                GroupRankList = statList.GroupScoreList.GroupBy(x => x.GroupNum).Select(x => new
                {
                    GroupNum = x.Key,
                    GroupList = x.Select(y => new
                    {
                        ExamNum = y.Sort,
                        y.ExamName,
                        Rank = y.Score,
                        y.TScore
                    })
                }),
                TRankScoreList = statList.TRankScoreList.Select(x => new
                {
                    ExamNum = x.Sort,
                    x.ExamName,
                    Rank = x.Score,
                    x.TScore
                })
            };
        }
    }
}
