﻿using EduSpider.Utility.Plugin;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Net.Http;
using System.Text;
using VTX.FW.Helper;

namespace EduSpider.Spiders.SchoolHouseKeeper
{
    /// <summary>
    /// 校区管理
    /// </summary>
    public class SchoolManager
    {
        /// <summary>
        /// 获取课程列表
        /// </summary>
        public static void RunSchool(string cookie)
        {
            var pageModel = new
            {
                PageSize = 999
            };
            int pageCount, totalCount;
            string url = "https://tms11.xiaogj.com/api/Area/ReportAreaList";
            string result;
            result = Utility.SchoolHttpHelper.HttpPost(url, VTX.FW.Helper.JsonHelper.Serialize(pageModel), "application/json", cookie);
            List<SchoolItem> list = new();
            if (!string.IsNullOrEmpty(result))
            {
                JObject jobj = JObject.Parse(result);
                pageCount = jobj.GetInt("PageCount");
                totalCount = jobj.GetInt("TotalCount");
                list.AddRange(ParseJson(jobj.GetString("Data")));
                InfoHelper.WriteLine(string.Format("已完成 总共 {0} 条", totalCount));
            }
            InfoHelper.WriteLine("result:" + VTX.FW.Helper.JsonHelper.Serialize(list));
        }



        /// <summary>
        /// 解析JSON
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<SchoolItem> ParseJson(string data)
        {
            List<SchoolItem> list = new();
            if (!string.IsNullOrEmpty(data))
            {
                JArray courseArray = JArray.Parse(data);
                if (courseArray != null && courseArray.Count > 0)
                {
                    foreach (var item in courseArray)
                    {
                        JObject cObj = JObject.Parse(item.ToString());

                        var model = new SchoolItem()
                        {
                            ID = cObj.GetString("ID"),
                            Name = cObj.GetString("Name"),
                            Describe = cObj.GetString("Describe"),
                            CreateTime = cObj.GetDateTime("CreateTime"),
                            ParentId = cObj.GetString("ParentId"),
                        };
                        list.Add(model);
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 获取部门列表
        /// </summary>
        /// <param name="cookie"></param>
        public static void RunDepartment(string cookie)
        {
            var pageModel = new
            {
                //  PageSize = 999
            };
            int pageCount, totalCount;
            string url = "https://tms11.xiaogj.com/api/depart/query";
            string result;
            result = Utility.SchoolHttpHelper.HttpPost(url, VTX.FW.Helper.JsonHelper.Serialize(pageModel), "application/json", cookie); ;
            List<DepartmentItem> list = new();
            if (!string.IsNullOrEmpty(result))
            {
                JObject jobj = JObject.Parse(result);
                pageCount = jobj.GetInt("PageCount");
                totalCount = jobj.GetInt("TotalCount");
                list.AddRange(ParseDepartJson(jobj.GetString("Data")));
                InfoHelper.WriteLine(string.Format("已完成 总共 {0} 条", totalCount));
            }
            InfoHelper.WriteLine("result:" + VTX.FW.Helper.JsonHelper.Serialize(list));
        }


        /// <summary>
        /// 解析JSON
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<DepartmentItem> ParseDepartJson(string data)
        {
            List<DepartmentItem> list = new();
            if (!string.IsNullOrEmpty(data))
            {
                JArray courseArray = JArray.Parse(data);
                if (courseArray != null && courseArray.Count > 0)
                {
                    foreach (var item in courseArray)
                    {
                        JObject cObj = JObject.Parse(item.ToString());

                        var model = new DepartmentItem()
                        {
                            ID = cObj.GetString("ID"),
                            Address = cObj.GetString("ID"),
                            AreaId = cObj.GetString("AreaId"),
                            AreaName = cObj.GetString("AreaName"),
                            CategoryName = cObj.GetString("CategoryName"),
                            Leader = cObj.GetString("Leader"),
                            parentId = cObj.GetString("parentId"),
                            Name = cObj.GetString("Name"),
                        };
                        list.Add(model);
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 获取员工列表
        /// </summary>
        /// <param name="cookie"></param>
        public static void RunEmployee(string cookie)
        {
            var pageModel = new PageModel
            {
                PageIndex = 1,
                PageSize = 20
            };
            int pageCount, totalCount;
            string url = "https://tms11.xiaogj.com/api/employee/Query";
            string result;

            result = Utility.SchoolHttpHelper.HttpPost(url, VTX.FW.Helper.JsonHelper.Serialize(pageModel), "application/json", cookie); ;
            List<EmployeeItem> list = new();
            if (!string.IsNullOrEmpty(result))
            {
                JObject jobj = JObject.Parse(result);
                pageCount = jobj.GetInt("PageCount");
                totalCount = jobj.GetInt("TotalCount");
                list.AddRange(ParseEmployeeJson(jobj.GetString("Data")));
                InfoHelper.WriteLine(string.Format("已完成 总共 {0} 条", totalCount));
            }
            InfoHelper.WriteLine("result:" + VTX.FW.Helper.JsonHelper.Serialize(list));
        }

        /// <summary>
        /// 解析JSON
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<EmployeeItem> ParseEmployeeJson(string data)
        {
            List<EmployeeItem> list = new();
            if (!string.IsNullOrEmpty(data))
            {
                JArray courseArray = JArray.Parse(data);
                if (courseArray != null && courseArray.Count > 0)
                {
                    foreach (var item in courseArray)
                    {
                        JObject cObj = JObject.Parse(item.ToString());
                        var model = new EmployeeItem()
                        {
                            ID = cObj.GetString("ID"),
                            Name = cObj.GetString("Name"),
                            SMSTel = cObj.GetString("SMSTel"),
                            Serial = cObj.GetString("Serial"),
                        };
                        list.Add(model);
                    }
                }
            }
            return list;
        }
    }

    /// <summary>
    /// 校区信息
    /// </summary>
    public class SchoolItem
    {
        /// <summary>
        /// 校区编号
        /// </summary>
        public string ID { get; set; }

        /// <summary>
        /// 校区名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        public string Describe { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateTime { get; set; }

        /// <summary>
        /// 父节点GUID
        /// </summary>
        public string ParentId { get; set; }
    }

    /// <summary>
    /// 部门信息
    /// </summary>
    public class DepartmentItem
    {
        public string Address { get; set; }

        /// <summary>
        /// 校区Id
        /// </summary>
        public string AreaId { get; set; }

        /// <summary>
        /// 校区名称
        /// </summary>
        public string AreaName { get; set; }

        /// <summary>
        /// 分类名称
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// 部门编号
        /// </summary>
        public string ID { get; set; }

        /// <summary>
        /// 负责人
        /// </summary>
        public string Leader { get; set; }

        /// <summary>
        /// 父级部门编号
        /// </summary>
        public string parentId { get; set; }

        /// <summary>
        /// 部门名称
        /// </summary>
        public string Name { get; set; }
    }

    /// <summary>
    /// 员工信息
    /// </summary>
    public class EmployeeItem
    {
        /// <summary>
        /// 员工编号
        /// </summary>
        public string ID { get; set; }

        /// <summary>
        /// 员工姓名
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 电话
        /// </summary>
        public string SMSTel { get; set; }

        /// <summary>
        /// 工号
        /// </summary>
        public string Serial { get; set; }
    }
}
